/*
 * Decompiled with CFR 0.152.
 */
package org.icepush;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import org.icepush.NotificationEvent;
import org.icepush.NotificationListener;
import org.icepush.NotificationProvider;

public abstract class AbstractNotificationProvider
implements NotificationProvider {
    private static final Logger LOGGER = Logger.getLogger(AbstractNotificationProvider.class.getName());
    private final Set<NotificationListener> listenerSet = new CopyOnWriteArraySet<NotificationListener>();

    public void addNotificationProviderListener(NotificationListener listener) {
        this.listenerSet.add(listener);
    }

    public void removeNotificationProviderListener(NotificationListener listener) {
        this.listenerSet.remove(listener);
    }

    protected void notificationSent(NotificationEvent event) {
        for (NotificationListener listener : this.listenerSet) {
            listener.notificationSent(event);
        }
    }
}

