/*
 * Decompiled with CFR 0.152.
 */
package org.icepush;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.icepush.InternalPushGroupManager;
import org.icepush.PushGroupEvent;
import org.icepush.PushGroupListener;
import org.icepush.PushGroupManager;

public abstract class AbstractPushGroupManager
implements InternalPushGroupManager,
PushGroupManager {
    private static final Logger LOGGER = Logger.getLogger(AbstractPushGroupManager.class.getName());
    private final Set<PushGroupListener> pushGroupListenerSet = new HashSet<PushGroupListener>();

    public void addPushGroupListener(PushGroupListener listener) {
        if (!this.pushGroupListenerSet.contains(listener)) {
            this.pushGroupListenerSet.add(listener);
        }
    }

    public void groupTouched(String groupName, long timestamp) {
        PushGroupEvent _event = new PushGroupEvent(this, groupName, null, timestamp);
        for (PushGroupListener listener : this.pushGroupListenerSet) {
            listener.groupTouched(_event);
        }
    }

    public void removePushGroupListener(PushGroupListener listener) {
        if (this.pushGroupListenerSet.contains(listener)) {
            this.pushGroupListenerSet.remove(listener);
        }
    }

    protected void memberAdded(String groupName, String pushId) {
        PushGroupEvent _event = new PushGroupEvent(this, groupName, pushId, null);
        for (PushGroupListener listener : this.pushGroupListenerSet) {
            listener.memberAdded(_event);
        }
    }

    protected void memberRemoved(String groupName, String pushId) {
        PushGroupEvent _event = new PushGroupEvent(this, groupName, pushId, null);
        for (PushGroupListener listener : this.pushGroupListenerSet) {
            listener.memberRemoved(_event);
        }
    }

    protected void pushed(String groupName) {
        PushGroupEvent _event = new PushGroupEvent(this, groupName, null, null);
        for (PushGroupListener listener : this.pushGroupListenerSet) {
            listener.pushed(_event);
        }
    }

    protected void pushIDTouched(String pushId, Long timestamp) {
        PushGroupEvent _event = new PushGroupEvent(this, null, pushId, timestamp);
        for (PushGroupListener listener : this.pushGroupListenerSet) {
            listener.pushIDTouched(_event);
        }
    }
}

