/*
 * Decompiled with CFR 0.152.
 */
package org.icepush;

import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepush.BackOff;
import org.icepush.Browser;
import org.icepush.Configuration;
import org.icepush.ConnectionClose;
import org.icepush.Noop;
import org.icepush.NotificationBroadcaster;
import org.icepush.NotificationEntry;
import org.icepush.NotificationEvent;
import org.icepush.NotificationListener;
import org.icepush.NotifiedPushIDs;
import org.icepush.PushGroupManager;
import org.icepush.PushID;
import org.icepush.PushInternalContext;
import org.icepush.ServerError;
import org.icepush.http.PushRequest;
import org.icepush.http.PushResponse;
import org.icepush.http.PushResponseHandler;
import org.icepush.http.PushServer;
import org.icepush.http.standard.PushResponseHandlerServer;
import org.icepush.util.Slot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingConnectionServer
extends TimerTask
implements NotificationBroadcaster.Receiver,
PushServer {
    private static final Logger LOGGER = Logger.getLogger(BlockingConnectionServer.class.getName());
    private static final String[] STRINGS = new String[0];
    private static final PushResponseHandler NOOP_SHUTDOWN = new Noop("shutdown");
    private static final PushResponseHandler NOOP_TIMEOUT = new Noop("response timeout");
    private final PushResponseHandler closeConnectionDuplicate = new ConnectionClose("duplicate"){

        public void respond(PushResponse pushResponse) throws Exception {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Received duplicate listen.icepush request for Browser-ID '" + BlockingConnectionServer.this.getBrowserID() + "'.");
            }
            super.respond(pushResponse);
            BlockingConnectionServer.this.pushGroupManager.getBrowser(BlockingConnectionServer.this.getBrowserID()).getStatus().revertConnectionRecreationTimeout();
        }
    };
    private final PushResponseHandler closeConnectionShutdown = new ConnectionClose("shutdown");
    private final PushServer AfterShutdown = new PushResponseHandlerServer(this.closeConnectionShutdown);
    private final BlockingQueue<PushRequest> pendingRequest = new LinkedBlockingQueue<PushRequest>(1);
    private final Slot heartbeatInterval;
    private final PushGroupManager pushGroupManager = (PushGroupManager)PushInternalContext.getInstance().getAttribute(PushGroupManager.class.getName());
    private final long minCloudPushInterval;
    private final long maxHeartbeatInterval;
    private final long minHeartbeatInterval;
    private final Set<NotificationListener> listenerSet = new CopyOnWriteArraySet<NotificationListener>();
    private String browserID;
    private long responseTimeoutTime;
    private PushServer activeServer;
    private Timer monitoringScheduler;
    private String lastWindow = "";
    private long defaultConnectionRecreationTimeout;
    private long responseTimestamp = System.currentTimeMillis();
    private long requestTimestamp = System.currentTimeMillis();
    private long backOffDelay = 0L;
    private boolean setUp = false;

    public BlockingConnectionServer(String browserID, Timer monitoringScheduler, Slot heartbeat, boolean terminateBlockingConnectionOnShutdown, Configuration configuration) {
        this.minCloudPushInterval = configuration.getAttributeAsLong("minCloudPushInterval", 10000L);
        this.browserID = browserID;
        this.monitoringScheduler = monitoringScheduler;
        this.heartbeatInterval = heartbeat;
        this.defaultConnectionRecreationTimeout = configuration.getAttributeAsLong("connectionRecreationTimeout", 5000L);
        this.pushGroupManager.addNotificationReceiver(this);
        this.maxHeartbeatInterval = configuration.getAttributeAsLong("maxHeartbeatInterval", Math.round(3L * heartbeat.getLongValue()));
        this.minHeartbeatInterval = configuration.getAttributeAsLong("minHeartbeatInterval", heartbeat.getLongValue() / 3L);
        this.activeServer = new RunningServer(terminateBlockingConnectionOnShutdown);
    }

    public void addNotificationListener(NotificationListener listener) {
        this.listenerSet.add(listener);
    }

    public synchronized void backOff(long delay) throws IllegalStateException {
        this.checkSetUp();
        if (delay > 0L) {
            this.backOffDelay = delay;
            this.respondIfBackOffRequested();
        }
    }

    public String getBrowserID() {
        return this.browserID;
    }

    @Override
    public boolean isInterested(Set<NotificationEntry> notificationEntrySet) {
        for (NotificationEntry _notificationEntry : notificationEntrySet) {
            if (!this.getPushGroupManager().getBrowser(this.getBrowserID()).getPushIDSet().contains(_notificationEntry.getPushID())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void receive(Set<NotificationEntry> notificationSet) throws IllegalStateException {
        this.checkSetUp();
        this.sendNotifications(notificationSet);
    }

    public void removeNotificationListener(NotificationListener listener) {
        this.listenerSet.remove(listener);
    }

    @Override
    public void run() throws IllegalStateException {
        block3: {
            this.checkSetUp();
            try {
                if (System.currentTimeMillis() > this.responseTimeoutTime) {
                    this.respondIfPendingRequest(NOOP_TIMEOUT);
                }
            }
            catch (Exception exception) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block3;
                LOGGER.log(Level.WARNING, "Exception caught on " + this.getClass().getName() + " TimerTask.", exception);
            }
        }
    }

    @Override
    public void service(PushRequest pushRequest) throws Exception, IllegalStateException {
        this.checkSetUp();
        this.activeServer.service(pushRequest);
    }

    public void setUp() {
        this.pushGroupManager.addBrowser(this.newBrowser(this.getBrowserID(), this.getMinCloudPushInterval()));
        this.pushGroupManager.addBlockingConnectionServer(this.getBrowserID(), this);
        this.setUp = true;
        this.monitoringScheduler.scheduleAtFixedRate((TimerTask)this, 0L, 1000L);
    }

    @Override
    public void shutdown() throws IllegalStateException {
        this.checkSetUp();
        this.cancel();
        this.pushGroupManager.deleteNotificationReceiver(this);
        this.pushGroupManager.removeBlockingConnectionServer(this.getBrowserID());
        this.pushGroupManager.removeBrowser(this.pushGroupManager.getBrowser(this.getBrowserID()));
        this.activeServer.shutdown();
    }

    protected void checkSetUp() throws IllegalStateException {
        if (!this.setUp) {
            throw new IllegalStateException("Blocking Connection Server has not been set-up.");
        }
    }

    protected long getMinCloudPushInterval() {
        return this.minCloudPushInterval;
    }

    protected PushGroupManager getPushGroupManager() {
        return this.pushGroupManager;
    }

    protected Browser newBrowser(String browserID, long minCloudPushInterval) {
        return new Browser(browserID, minCloudPushInterval);
    }

    protected void notificationSent(NotificationEvent event) {
        for (NotificationListener listener : this.listenerSet) {
            listener.notificationSent(event);
        }
    }

    private void adjustConnectionRecreationTimeout(PushRequest pushRequest) {
        long currentResponseDelay;
        Browser browser = this.pushGroupManager.getBrowser(this.getBrowserID());
        for (String pushIDString : browser.getPushIDSet()) {
            PushID pushID = this.pushGroupManager.getPushID(pushIDString);
            if (pushID == null) continue;
            if (browser.getStatus().getConnectionRecreationTimeout() == -1L) {
                browser.getStatus().setConnectionRecreationTimeout(this.defaultConnectionRecreationTimeout);
            }
            browser.getStatus().backUpConnectionRecreationTimeout();
        }
        long now = System.currentTimeMillis();
        long elapsed = now - this.requestTimestamp;
        this.requestTimestamp = now;
        long responseDelay = currentResponseDelay = this.requestTimestamp - this.responseTimestamp;
        for (String pushIDString : browser.getPushIDSet()) {
            PushID pushID = this.pushGroupManager.getPushID(pushIDString);
            if (pushID == null) continue;
            responseDelay = Math.max(responseDelay, browser.getStatus().getConnectionRecreationTimeout() * 4L / 5L);
            responseDelay = Math.min(responseDelay, browser.getStatus().getConnectionRecreationTimeout() * 3L / 2L);
            responseDelay = Math.max(responseDelay, 500L);
            browser.getStatus().setConnectionRecreationTimeout((responseDelay + browser.getStatus().getConnectionRecreationTimeout() * 4L) / 5L);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            this.setNotifyBackURI(pushRequest);
            LOGGER.log(Level.FINE, "ICEpush metric: IP: " + pushRequest.getRemoteAddr() + " pushIds: " + browser.getPushIDSet() + " Cloud Push ID: " + browser.getNotifyBackURI() + " Browser: " + browser.getID() + " last request: " + elapsed + " Latency: " + currentResponseDelay);
        }
    }

    private void recordResponseTime() {
        this.responseTimestamp = System.currentTimeMillis();
    }

    private void resendLastNotifications() {
        this.sendNotifications(this.pushGroupManager.getBrowser(this.getBrowserID()).getLastNotifiedPushIDSet());
    }

    private void resetTimeout(PushRequest pushRequest) {
        long clientSideHeartbeatInterval;
        if (pushRequest != null) {
            try {
                clientSideHeartbeatInterval = pushRequest.getHeartbeatInterval();
            }
            catch (NumberFormatException exception) {
                clientSideHeartbeatInterval = Long.MAX_VALUE;
            }
        } else {
            clientSideHeartbeatInterval = Long.MAX_VALUE;
        }
        long serverSideHeartbeatInterval = this.heartbeatInterval.getLongValue();
        long heartbeatInterval = Math.min(Math.max(Math.min(clientSideHeartbeatInterval, serverSideHeartbeatInterval), this.minHeartbeatInterval), this.maxHeartbeatInterval);
        this.responseTimeoutTime = System.currentTimeMillis() + heartbeatInterval;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Heartbeat Interval: client-side '" + clientSideHeartbeatInterval + "', " + "server-side '" + serverSideHeartbeatInterval + "', " + "used '" + heartbeatInterval + "'.");
        }
    }

    private synchronized boolean respondIfBackOffRequested() {
        boolean _result = false;
        if (this.backOffDelay > 0L && (_result = this.respondIfPendingRequest(new BackOff(this.backOffDelay)))) {
            this.backOffDelay = 0L;
        }
        return _result;
    }

    private synchronized void respondIfNotificationsAvailable() {
        if (this.pushGroupManager.getBrowser(this.getBrowserID()).hasNotifiedPushIDs()) {
            this.pushGroupManager.getBrowser(this.getBrowserID()).setLastNotifiedPushIDSet(this.pushGroupManager.getBrowser(this.getBrowserID()).getNotifiedPushIDSet());
            this.respondIfPendingRequest(new NotifiedPushIDs(this.pushGroupManager.getBrowser(this.getBrowserID()).getLastNotifiedPushIDSet()){

                public void writeTo(Writer writer) throws IOException {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Send Notifications for Browser-ID '" + BlockingConnectionServer.this.getBrowserID() + "' " + "with Push-IDs '" + this.getPushIDSet() + "'.");
                    }
                    super.writeTo(writer);
                    BlockingConnectionServer.this.pushGroupManager.clearPendingNotifications(BlockingConnectionServer.this.pushGroupManager.getBrowser(BlockingConnectionServer.this.getBrowserID()).getPushIDSet());
                    BlockingConnectionServer.this.pushGroupManager.getBrowser(BlockingConnectionServer.this.getBrowserID()).removeNotifiedPushIDs(BlockingConnectionServer.this.pushGroupManager.getBrowser(BlockingConnectionServer.this.getBrowserID()).getLastNotifiedPushIDSet());
                    HashSet<String> groupNameSet = new HashSet<String>();
                    for (NotificationEntry notificationEntry : BlockingConnectionServer.this.pushGroupManager.getBrowser(BlockingConnectionServer.this.getBrowserID()).getLastNotifiedPushIDSet()) {
                        String groupName = notificationEntry.getGroupName();
                        if (groupNameSet.add(groupName)) {
                            BlockingConnectionServer.this.notificationSent(new NotificationEvent(NotificationEvent.TargetType.BROWSER_ID, BlockingConnectionServer.this.getBrowserID(), groupName, NotificationEvent.NotificationType.PUSH, this));
                        }
                        BlockingConnectionServer.this.notificationSent(new NotificationEvent(NotificationEvent.TargetType.PUSH_ID, notificationEntry.getPushID(), groupName, NotificationEvent.NotificationType.PUSH, this));
                    }
                }
            });
        }
    }

    private boolean respondIfPendingRequest(PushResponseHandler handler) {
        PushRequest previousRequest = (PushRequest)this.pendingRequest.poll();
        if (previousRequest != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Pending request for PushIDs '" + this.pushGroupManager.getBrowser(this.getBrowserID()).getPushIDSet() + "', " + "trying to respond.");
            }
            try {
                this.recordResponseTime();
                previousRequest.respondWith(handler);
                return true;
            }
            catch (IOException e) {
                LOGGER.fine("Possible communication issue encountered while responding: " + e.getMessage());
                return true;
            }
            catch (Exception e) {
                LOGGER.severe("Failed to respond to pending request: " + e.getMessage());
                return true;
            }
        }
        return false;
    }

    private synchronized boolean sendNotifications(Set<NotificationEntry> notificationSet) {
        boolean anyNotifications;
        HashSet<NotificationEntry> matchingSet = new HashSet<NotificationEntry>();
        for (NotificationEntry notificationEntry : notificationSet) {
            if (!this.pushGroupManager.getBrowser(this.getBrowserID()).getPushIDSet().contains(notificationEntry.getPushID())) continue;
            matchingSet.add(notificationEntry);
        }
        boolean bl = anyNotifications = !matchingSet.isEmpty();
        if (anyNotifications) {
            this.pushGroupManager.getBrowser(this.getBrowserID()).addNotifiedPushIDs(matchingSet);
            this.pushGroupManager.getBrowser(this.getBrowserID()).retainNotifiedPushIDs(this.pushGroupManager.getPendingNotificationSet());
            this.resetTimeout((PushRequest)this.pendingRequest.peek());
            this.respondIfNotificationsAvailable();
        }
        return anyNotifications;
    }

    private void setNotifyBackURI(PushRequest pushRequest) {
        String notifyBack = pushRequest.getNotifyBackURI();
        if (notifyBack != null && notifyBack.trim().length() != 0) {
            this.pushGroupManager.getBrowser(this.getBrowserID()).setNotifyBackURI(this.pushGroupManager.newNotifyBackURI(notifyBack), true);
        }
    }

    private class RunningServer
    implements PushServer {
        private final boolean terminateBlockingConnectionOnShutdown;

        public RunningServer(boolean terminateBlockingConnectionOnShutdown) {
            this.terminateBlockingConnectionOnShutdown = terminateBlockingConnectionOnShutdown;
        }

        public void service(PushRequest pushRequest) throws Exception {
            BlockingConnectionServer.this.resetTimeout(pushRequest);
            try {
                long sequenceNumber;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Received listen.icepush request from Browser-ID '" + pushRequest.getBrowserID() + "' " + "for Push-IDs '" + pushRequest.getPushIDSet() + "'.");
                }
                BlockingConnectionServer.this.pushGroupManager.getBrowser(BlockingConnectionServer.this.getBrowserID()).setPushIDSet(pushRequest.getPushIDSet());
                BlockingConnectionServer.this.adjustConnectionRecreationTimeout(pushRequest);
                BlockingConnectionServer.this.respondIfPendingRequest(BlockingConnectionServer.this.closeConnectionDuplicate);
                try {
                    sequenceNumber = pushRequest.getSequenceNumber();
                }
                catch (RuntimeException exception) {
                    sequenceNumber = 0L;
                }
                BlockingConnectionServer.this.pushGroupManager.getBrowser(BlockingConnectionServer.this.getBrowserID()).setSequenceNumber(sequenceNumber);
                String currentWindow = pushRequest.getWindowID();
                currentWindow = currentWindow == null ? "" : currentWindow;
                boolean resend = !BlockingConnectionServer.this.lastWindow.equals(currentWindow);
                BlockingConnectionServer.this.lastWindow = currentWindow;
                BlockingConnectionServer.this.pendingRequest.put(pushRequest);
                BlockingConnectionServer.this.setNotifyBackURI(pushRequest);
                BlockingConnectionServer.this.pushGroupManager.scan(BlockingConnectionServer.this.pushGroupManager.getBrowser(BlockingConnectionServer.this.getBrowserID()).getPushIDSet().toArray(STRINGS));
                BlockingConnectionServer.this.pushGroupManager.getBrowser(BlockingConnectionServer.this.getBrowserID()).cancelConfirmationTimeout();
                BlockingConnectionServer.this.pushGroupManager.cancelExpiryTimeouts(BlockingConnectionServer.this.pushGroupManager.getBrowser(BlockingConnectionServer.this.getBrowserID()).getID());
                BlockingConnectionServer.this.pushGroupManager.startExpiryTimeouts(BlockingConnectionServer.this.pushGroupManager.getBrowser(BlockingConnectionServer.this.getBrowserID()).getID());
                if (null != BlockingConnectionServer.this.pushGroupManager.getBrowser(BlockingConnectionServer.this.getBrowserID()).getNotifyBackURI()) {
                    BlockingConnectionServer.this.pushGroupManager.pruneParkedIDs(BlockingConnectionServer.this.pushGroupManager.getBrowser(BlockingConnectionServer.this.getBrowserID()).getNotifyBackURI(), BlockingConnectionServer.this.pushGroupManager.getBrowser(BlockingConnectionServer.this.getBrowserID()).getPushIDSet());
                }
                if (!BlockingConnectionServer.this.respondIfBackOffRequested() && !BlockingConnectionServer.this.sendNotifications(BlockingConnectionServer.this.pushGroupManager.getPendingNotificationSet())) {
                    if (resend) {
                        BlockingConnectionServer.this.resendLastNotifications();
                    } else {
                        BlockingConnectionServer.this.respondIfNotificationsAvailable();
                    }
                }
            }
            catch (Throwable throwable) {
                LOGGER.log(Level.WARNING, "Failed to respond to request", throwable);
                BlockingConnectionServer.this.respondIfPendingRequest(new ServerError(throwable));
            }
        }

        public void shutdown() {
            BlockingConnectionServer.this.activeServer = BlockingConnectionServer.this.AfterShutdown;
            BlockingConnectionServer.this.respondIfPendingRequest(this.terminateBlockingConnectionOnShutdown ? BlockingConnectionServer.this.closeConnectionShutdown : NOOP_SHUTDOWN);
        }
    }
}

