/*
 * Decompiled with CFR 0.152.
 */
package org.icepush;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.icepush.InternalPushGroupManager;
import org.icepush.NotificationEntry;
import org.icepush.NotifyBackURI;
import org.icepush.PushConfiguration;
import org.icepush.PushGroupManager;
import org.icepush.PushInternalContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Browser
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(Browser.class.getName());
    public static final String BROWSER_ID_NAME = "ice.push.browser";
    private static AtomicInteger browserCounter = new AtomicInteger(0);
    private final String id;
    private final long minCloudPushInterval;
    private final ConcurrentLinkedQueue<NotificationEntry> notifiedPushIDQueue = new ConcurrentLinkedQueue();
    private Set<NotificationEntry> lastNotifiedPushIDSet = new HashSet<NotificationEntry>();
    private NotifyBackURI notifyBackURI;
    private PushConfiguration pushConfiguration;
    private Set<String> pushIDSet = Collections.emptySet();
    private Status status;

    public Browser(Browser browser) {
        this(browser.getID(), browser.getMinCloudPushInterval());
        this.setNotifyBackURI(browser.getNotifyBackURI(), false);
        this.setPushIDSet(browser.getPushIDSet());
        this.status = new Status(browser.getStatus());
    }

    public Browser(String id, long minCloudPushInterval) {
        this.id = id;
        this.minCloudPushInterval = minCloudPushInterval;
        this.status = this.newStatus();
    }

    public boolean addNotifiedPushIDs(Collection<NotificationEntry> notifiedPushIDCollection) {
        return this.notifiedPushIDQueue.addAll(notifiedPushIDCollection);
    }

    public boolean cancelConfirmationTimeout() {
        return ((InternalPushGroupManager)PushInternalContext.getInstance().getAttribute(PushGroupManager.class.getName())).cancelConfirmationTimeout(this.getID());
    }

    public static String generateBrowserID() {
        return Long.toString(browserCounter.incrementAndGet(), 36) + Long.toString(System.currentTimeMillis(), 36);
    }

    public static String getBrowserID(HttpServletRequest request) {
        return Browser.getBrowserIDFromParameter(request);
    }

    public String getID() {
        return this.id;
    }

    public Set<NotificationEntry> getLastNotifiedPushIDSet() {
        return Collections.unmodifiableSet(this.lastNotifiedPushIDSet);
    }

    public long getMinCloudPushInterval() {
        return this.minCloudPushInterval;
    }

    public Set<NotificationEntry> getNotifiedPushIDSet() {
        return Collections.unmodifiableSet(new HashSet<NotificationEntry>(this.notifiedPushIDQueue));
    }

    public NotifyBackURI getNotifyBackURI() {
        return this.notifyBackURI;
    }

    public PushConfiguration getPushConfiguration() {
        return this.pushConfiguration;
    }

    public Set<String> getPushIDSet() {
        return Collections.unmodifiableSet(this.pushIDSet);
    }

    public long getSequenceNumber() {
        return this.status.getSequenceNumber();
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean hasNotifiedPushIDs() {
        return !this.notifiedPushIDQueue.isEmpty();
    }

    public boolean removeNotifiedPushIDs(Collection<NotificationEntry> notifiedPushIDCollection) {
        return this.notifiedPushIDQueue.removeAll(notifiedPushIDCollection);
    }

    public boolean retainNotifiedPushIDs(Collection<NotificationEntry> notifiedPushIDCollection) {
        return this.notifiedPushIDQueue.retainAll(notifiedPushIDCollection);
    }

    public boolean setLastNotifiedPushIDSet(Set<NotificationEntry> lastNotifiedPushIDSet) {
        boolean _modified = false;
        if (!((Object)this.lastNotifiedPushIDSet).equals(lastNotifiedPushIDSet)) {
            this.lastNotifiedPushIDSet = new HashSet<NotificationEntry>(lastNotifiedPushIDSet);
            _modified = true;
        }
        return _modified;
    }

    public boolean setNotifyBackURI(NotifyBackURI notifyBackURI, boolean broadcastIfIsNew) {
        boolean _modified = false;
        if (this.notifyBackURI == null || !this.notifyBackURI.getURI().equals(notifyBackURI.getURI())) {
            this.notifyBackURI = notifyBackURI;
            _modified = true;
        } else {
            this.notifyBackURI.touch();
        }
        return _modified;
    }

    public boolean setPushConfiguration(PushConfiguration pushConfiguration) {
        boolean _modified = false;
        if (this.pushConfiguration == null && pushConfiguration != null || this.pushConfiguration != null && !this.pushConfiguration.equals(pushConfiguration)) {
            this.pushConfiguration = pushConfiguration;
            _modified = true;
        }
        return _modified;
    }

    public boolean setPushIDSet(Set<String> pushIDSet) {
        boolean _modified = false;
        if (this.pushIDSet == null && pushIDSet != null || this.pushIDSet != null && !((Object)this.pushIDSet).equals(pushIDSet)) {
            this.pushIDSet = new HashSet<String>(pushIDSet);
            _modified = true;
        }
        return _modified;
    }

    public boolean setSequenceNumber(long sequenceNumber) {
        return this.status.setSequenceNumber(sequenceNumber);
    }

    public boolean startConfirmationTimeout(String groupName) {
        return ((InternalPushGroupManager)PushInternalContext.getInstance().getAttribute(PushGroupManager.class.getName())).startConfirmationTimeout(this.getID(), groupName);
    }

    public boolean startConfirmationTimeout(String groupName, long sequenceNumber) {
        return ((InternalPushGroupManager)PushInternalContext.getInstance().getAttribute(PushGroupManager.class.getName())).startConfirmationTimeout(this.getID(), groupName, sequenceNumber);
    }

    public boolean startConfirmationTimeout(String groupName, long sequenceNumber, long timeout) {
        return ((InternalPushGroupManager)PushInternalContext.getInstance().getAttribute(PushGroupManager.class.getName())).startConfirmationTimeout(this.getID(), groupName, sequenceNumber, timeout);
    }

    public String toString() {
        return "Browser[" + this.membersAsString() + "]";
    }

    protected String membersAsString() {
        return "id: '" + this.getID() + "', " + "lastNotifiedPushIDSet: '" + this.getLastNotifiedPushIDSet() + "', " + "minCloudPushInterval: '" + this.getMinCloudPushInterval() + "', " + "notifiedPushIDSet: '" + this.getNotifiedPushIDSet() + "', " + "notifyBackURI: '" + this.getNotifyBackURI() + "', " + "pushConfiguration: '" + this.getPushConfiguration() + "', " + "pushIDSet: '" + this.getPushIDSet() + "', " + "status: '" + this.getStatus() + "'";
    }

    protected Status newStatus() {
        return new Status();
    }

    protected void setStatus(Status status) {
        this.status = status;
    }

    private static String getBrowserIDFromParameter(HttpServletRequest request) {
        return request.getParameter(BROWSER_ID_NAME);
    }

    public class Status
    implements Serializable {
        private static final long serialVersionUID = 2530024421926858382L;
        private long backupConnectionRecreationTimeout;
        private long connectionRecreationTimeout = -1L;
        private long sequenceNumber = -1L;

        protected Status() {
        }

        protected Status(Status status) {
            this.setBackupConnectionRecreationTimeout(status.getBackupConnectionRecreationTimeout());
            this.setConnectionRecreationTimeout(status.getConnectionRecreationTimeout());
            this.setSequenceNumber(status.getSequenceNumber());
        }

        public void backUpConnectionRecreationTimeout() {
            this.backupConnectionRecreationTimeout = this.connectionRecreationTimeout;
        }

        public long getBackupConnectionRecreationTimeout() {
            return this.backupConnectionRecreationTimeout;
        }

        public long getConnectionRecreationTimeout() {
            return this.connectionRecreationTimeout;
        }

        public long getSequenceNumber() {
            return this.sequenceNumber;
        }

        public boolean revertConnectionRecreationTimeout() {
            return this.setConnectionRecreationTimeout(this.getBackupConnectionRecreationTimeout());
        }

        public boolean setBackupConnectionRecreationTimeout(long backupConnectionRecreationTimeout) {
            if (this.backupConnectionRecreationTimeout != backupConnectionRecreationTimeout) {
                this.backupConnectionRecreationTimeout = backupConnectionRecreationTimeout;
                return true;
            }
            return false;
        }

        public boolean setConnectionRecreationTimeout(long connectionRecreationTimeout) {
            if (this.connectionRecreationTimeout != connectionRecreationTimeout) {
                this.connectionRecreationTimeout = connectionRecreationTimeout;
                return true;
            }
            return false;
        }

        public boolean setSequenceNumber(long sequenceNumber) {
            if (this.sequenceNumber != sequenceNumber) {
                this.sequenceNumber = sequenceNumber;
                return true;
            }
            return false;
        }

        public String toString() {
            return "Browser.Status[" + this.membersAsString() + "]";
        }

        protected String membersAsString() {
            return "backupConnectionRecreationTimeout: " + "'" + this.getBackupConnectionRecreationTimeout() + "', " + "connectionRecreationTimeout: " + "'" + this.getConnectionRecreationTimeout() + "', " + "sequenceNumber: " + "'" + this.getSequenceNumber() + "'";
        }
    }
}

