/*
 * Decompiled with CFR 0.152.
 */
package org.icepush;

import java.io.IOException;
import java.io.Writer;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.icepush.Configuration;
import org.icepush.http.PushRequest;
import org.icepush.http.PushResponse;
import org.icepush.http.PushResponseHandler;
import org.icepush.http.PushServer;
import org.icepush.http.standard.FixedXMLContentHandler;
import org.icepush.util.Slot;

public class ConfigurationServer
implements PushServer {
    private static final Logger log = Logger.getLogger(ConfigurationServer.class.getName());
    private static final String defaultServerErrorRetries = "1000 2000 4000";
    private static final int defaultEmptyResponseRetries = 3;
    public static final int DefaultHeartbeatTimeout = 15000;
    private Slot heartbeatInterval;
    private Configuration configuration;
    private PushServer server;
    private boolean nonDefaultConfiguration;
    private boolean redirect;
    private final String contextPath;
    private final String serverErrorRetries;
    private final int emptyResponseRetries;

    public ConfigurationServer(Slot heartbeatInterval, ServletContext servletContext, Configuration configuration, PushServer server) {
        this.heartbeatInterval = heartbeatInterval;
        this.server = server;
        this.configuration = configuration;
        this.contextPath = ConfigurationServer.normalizeContextPath(this.configuration.getAttribute("contextPath", (String)servletContext.getAttribute("contextPath")));
        this.serverErrorRetries = this.configuration.getAttribute("serverErrorRetryTimeouts", defaultServerErrorRetries);
        this.emptyResponseRetries = this.configuration.getAttributeAsInteger("emptyResponseRetries", 3);
        this.redirect = this.contextPath != null && !servletContext.getContextPath().equals(this.contextPath);
        this.nonDefaultConfiguration = this.emptyResponseRetries != 3 || !this.serverErrorRetries.equals(defaultServerErrorRetries) || this.contextPath != null;
    }

    private static String normalizeContextPath(String path) {
        if (path == null) {
            return null;
        }
        return path.startsWith("/") ? path : "/" + path;
    }

    public void service(PushRequest request) throws Exception {
        if ((this.redirect || request.containsParameter("ice.sendConfiguration")) && (this.nonDefaultConfiguration || this.heartbeatInterval.getLongValue() != 15000L)) {
            String configurationMessage = "<configuration" + (this.heartbeatInterval.getLongValue() != 15000L ? " heartbeatTimeout=\"" + this.heartbeatInterval.getLongValue() + "\"" : "") + (this.emptyResponseRetries != 3 ? " emptyResponseRetries=\"" + this.emptyResponseRetries + "\"" : "") + (!this.serverErrorRetries.equals(defaultServerErrorRetries) ? " serverErrorRetryTimeouts=\"" + this.serverErrorRetries + "\"" : "") + (this.contextPath != null ? " blockingConnectionURI=\"" + this.contextPath + "/listen.icepush\"" : "") + (this.contextPath != null ? " contextPath=\"" + this.contextPath + "\"" : "") + "/>";
            request.respondWith(new ConfigureBridge(configurationMessage));
        } else {
            this.server.service(request);
        }
    }

    public void shutdown() {
        this.server.shutdown();
    }

    private static class ConfigureBridge
    extends FixedXMLContentHandler
    implements PushResponseHandler {
        private String configurationMessage;

        private ConfigureBridge(String configurationMessage) {
            this.configurationMessage = configurationMessage;
        }

        public void writeTo(Writer writer) throws IOException {
            writer.write(this.configurationMessage);
            log.fine("Re-configured bridge.");
        }

        public void respond(PushResponse pushResponse) throws Exception {
            super.respond(pushResponse);
        }
    }
}

