/*
 * Decompiled with CFR 0.152.
 */
package org.icepush;

import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepush.Browser;
import org.icepush.LocalPushGroupManager;
import org.icepush.NotifyBackURI;
import org.icepush.PushGroupManager;
import org.icepush.PushInternalContext;
import org.icepush.PushNotification;

public class ConfirmationTimeout
extends TimerTask {
    private static final Logger LOGGER = Logger.getLogger(ConfirmationTimeout.class.getName());
    protected final LocalPushGroupManager localPushGroupManager = (LocalPushGroupManager)PushInternalContext.getInstance().getAttribute(PushGroupManager.class.getName());
    private final String browserID;
    private final String groupName;
    private final long minCloudPushInterval;
    private final long timeout;

    protected ConfirmationTimeout(String browserID, String groupName, long timeout, long minCloudPushInterval) {
        this.browserID = browserID;
        this.groupName = groupName;
        this.timeout = timeout;
        this.minCloudPushInterval = minCloudPushInterval;
    }

    public void run() {
        block7: {
            Browser _browser = this.localPushGroupManager.getBrowser(this.getBrowserID());
            NotifyBackURI _notifyBackURI = _browser.getNotifyBackURI();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Confirmation timeout occurred for Browser '" + this.getBrowserID() + "' " + "(URI: '" + _notifyBackURI + "', timeout: '" + this.getTimeout() + "').");
            }
            try {
                if (_notifyBackURI != null) {
                    for (String _pushIDString : _browser.getPushIDSet()) {
                        this.localPushGroupManager.park(_pushIDString, _notifyBackURI);
                    }
                    if (_notifyBackURI.getTimestamp() + this.getMinCloudPushInterval() <= System.currentTimeMillis()) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "Cloud Push dispatched for Browser '" + this.getBrowserID() + "'.");
                        }
                        _notifyBackURI.touch();
                        this.localPushGroupManager.getOutOfBandNotifier().broadcast(new PushNotification(_browser.getPushConfiguration().getAttributes()), new String[]{this.getBrowserID()}, this.groupName);
                        this.localPushGroupManager.clearPendingNotifications(_browser.getPushIDSet());
                        _browser.removeNotifiedPushIDs(_browser.getLastNotifiedPushIDSet());
                    }
                }
                _browser.cancelConfirmationTimeout();
            }
            catch (Exception exception) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block7;
                LOGGER.log(Level.WARNING, "Exception caught on confirmationTimeout TimerTask.", exception);
            }
        }
    }

    protected String getBrowserID() {
        return this.browserID;
    }

    protected String getGroupName() {
        return this.groupName;
    }

    protected long getMinCloudPushInterval() {
        return this.minCloudPushInterval;
    }

    protected long getTimeout() {
        return this.timeout;
    }
}

