/*
 * Decompiled with CFR 0.152.
 */
package org.icepush;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.icepush.Configuration;
import org.icepush.ConfigurationException;

public class DefaultConfiguration
extends Configuration {
    private static final Logger LOGGER = Logger.getLogger(DefaultConfiguration.class.getName());
    private final Map<String, String> defaultParameterMap = new HashMap<String, String>();
    private final Configuration configuration;

    public DefaultConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public String getAttribute(String name) throws ConfigurationException {
        try {
            return this.configuration.getAttribute(name);
        }
        catch (ConfigurationException exception) {
            if (this.defaultParameterMap.containsKey(name)) {
                return this.defaultParameterMap.get(name);
            }
            throw exception;
        }
    }

    public Configuration getChild(String child) throws ConfigurationException {
        return new DefaultConfiguration(this.configuration.getChild(child));
    }

    public Configuration[] getChildren(String name) throws ConfigurationException {
        Configuration[] children = this.configuration.getChildren(name);
        Configuration[] wrappedChildren = new Configuration[children.length];
        for (int i = 0; i < children.length; ++i) {
            wrappedChildren[i] = new DefaultConfiguration(children[i]);
        }
        return wrappedChildren;
    }

    public String getName() {
        return this.configuration.getName();
    }

    public String getValue() throws ConfigurationException {
        return this.configuration.getValue();
    }

    public void setAttributeDefault(String name, boolean value) {
        this.setAttributeDefault(name, Boolean.toString(value));
    }

    public void setAttributeDefault(String name, double value) {
        this.setAttributeDefault(name, Double.toString(value));
    }

    public void setAttributeDefault(String name, float value) {
        this.setAttributeDefault(name, Float.toString(value));
    }

    public void setAttributeDefault(String name, int value) {
        this.setAttributeDefault(name, Integer.toString(value));
    }

    public void setAttributeDefault(String name, long value) {
        this.setAttributeDefault(name, Long.toString(value));
    }

    public void setAttributeDefault(String name, String value) {
        this.defaultParameterMap.put(name, value);
    }
}

