/*
 * Decompiled with CFR 0.152.
 */
package org.icepush;

import java.net.URI;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.icepush.AbstractNotificationProvider;
import org.icepush.Configuration;
import org.icepush.LocalPushGroupManager;
import org.icepush.NotificationEvent;
import org.icepush.NotificationProvider;
import org.icepush.OutOfBandNotifier;
import org.icepush.PushGroupManager;
import org.icepush.PushInternalContext;
import org.icepush.PushNotification;
import org.icepush.servlet.ServletContextConfiguration;
import org.icepush.util.ExtensionRegistry;

public class EmailNotificationProvider
extends AbstractNotificationProvider
implements NotificationProvider {
    private static final Logger log = Logger.getLogger(EmailNotificationProvider.class.getName());
    private static final String SECURITY_NONE = "NONE";
    private static final String SECURITY_SSL = "SSL";
    private static final String SECURITY_TLS = "TLS";
    private Session session;
    private InternetAddress fromAddress;
    private String user;
    private String password;
    private String host;
    private int port;
    private String protocol;

    public EmailNotificationProvider(Configuration configuration) {
        this.host = configuration.getAttribute("host", "localhost");
        String from = configuration.getAttribute("from", "nobody@localhost.com");
        this.user = configuration.getAttribute("user", "");
        this.password = configuration.getAttribute("password", "");
        boolean verifyServerCertificate = configuration.getAttributeAsBoolean("verify-server-certificate", false);
        boolean debugSMTP = configuration.getAttributeAsBoolean("debug", false);
        String securityType = configuration.getAttribute("security", SECURITY_NONE);
        boolean secured = SECURITY_TLS.equals(securityType) || SECURITY_SSL.equals(securityType);
        int defaultPort = secured ? 465 : 25;
        this.port = configuration.getAttributeAsInteger("port", defaultPort);
        this.protocol = secured ? "smtps" : "smtp";
        try {
            Properties properties = new Properties();
            properties.setProperty("mail.smtp.auth", "true");
            if (debugSMTP) {
                properties.setProperty("mail.debug", "true");
            }
            if (SECURITY_TLS.equals(securityType)) {
                properties.put("mail.smtp.starttls.enable", "true");
                properties.put("mail.smtp.ssl.protocols", "TLSv1");
            }
            if (SECURITY_SSL.equals(securityType)) {
                properties.put("mail.smtp.ssl.enable", "true");
                properties.put("mail.smtp.ssl.protocols", "SSLv3");
            }
            if (!verifyServerCertificate) {
                properties.setProperty("mail.smtps.socketFactory.class", "org.icepush.DummySSLSocketFactory");
                properties.setProperty("mail.smtps.socketFactory.fallback", "false");
            }
            String passwordHash = "";
            if (null != this.password) {
                passwordHash = String.valueOf(this.password.hashCode()) + "(hash)";
            }
            log.info("ICEpush Email Notification Provider Properties " + properties + " " + from + " " + this.user + ":" + passwordHash + "@" + this.host + ":" + this.port);
            this.session = Session.getInstance((Properties)properties);
            this.fromAddress = new InternetAddress(from);
        }
        catch (AddressException e) {
            throw new RuntimeException(e);
        }
    }

    public void registerWith(OutOfBandNotifier outOfBandNotifier) {
        outOfBandNotifier.registerProvider("mail", this);
    }

    public void send(String browserID, String groupName, PushNotification notification) {
        new SendMessage(browserID, groupName, notification).start();
    }

    private class SendMessage
    extends Thread {
        private final String browserID;
        private final String groupName;
        private final PushNotification notification;

        public SendMessage(String browserID, String groupName, PushNotification notification) {
            this.browserID = browserID;
            this.groupName = groupName;
            this.notification = notification;
        }

        public void run() {
            URI destinationURI = URI.create(((LocalPushGroupManager)PushInternalContext.getInstance().getAttribute(PushGroupManager.class.getName())).getBrowser(this.browserID).getNotifyBackURI().getURI());
            MimeMessage mimeMessage = new MimeMessage(EmailNotificationProvider.this.session);
            try {
                mimeMessage.setFrom((Address)EmailNotificationProvider.this.fromAddress);
                InternetAddress address = new InternetAddress(destinationURI.getSchemeSpecificPart());
                mimeMessage.setSubject(this.notification.getSubject());
                mimeMessage.setText(this.notification.getDetail());
                Transport transport = EmailNotificationProvider.this.session.getTransport(EmailNotificationProvider.this.protocol);
                transport.connect(EmailNotificationProvider.this.host, EmailNotificationProvider.this.port, EmailNotificationProvider.this.user, EmailNotificationProvider.this.password);
                transport.sendMessage((Message)mimeMessage, (Address[])new InternetAddress[]{address});
                EmailNotificationProvider.this.notificationSent(new NotificationEvent(NotificationEvent.TargetType.BROWSER_ID, this.browserID, this.groupName, NotificationEvent.NotificationType.CLOUD_PUSH, EmailNotificationProvider.this));
            }
            catch (MessagingException ex) {
                log.log(Level.WARNING, "Failed to send email message.", ex);
            }
        }
    }

    public static class AutoRegister
    implements ServletContextListener {
        private static final Logger LOGGER = Logger.getLogger(AutoRegister.class.getName());

        public void contextInitialized(ServletContextEvent servletContextEvent) {
            try {
                Class.forName("javax.mail.Message");
                ServletContext servletContext = servletContextEvent.getServletContext();
                ServletContextConfiguration configuration = new ServletContextConfiguration("smtp", servletContext);
                ExtensionRegistry.addExtension(servletContext, 10, NotificationProvider.class.getName(), new EmailNotificationProvider(configuration));
                LOGGER.info("ICEpush Email Notification Provider Registered.");
            }
            catch (ClassNotFoundException e) {
                LOGGER.fine("Could not setup the email notification provider, the mail.jar library is missing.");
            }
        }

        public void contextDestroyed(ServletContextEvent servletContextEvent) {
        }
    }
}

