/*
 * Decompiled with CFR 0.152.
 */
package org.icepush;

import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepush.InternalPushGroupManager;
import org.icepush.PushGroupManager;
import org.icepush.PushID;
import org.icepush.PushInternalContext;

public class ExpiryTimeout
extends TimerTask
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(ExpiryTimeout.class.getName());
    protected final InternalPushGroupManager internalPushGroupManager = (InternalPushGroupManager)PushInternalContext.getInstance().getAttribute(PushGroupManager.class.getName());
    private final String pushID;
    private final boolean isCloudPushID;

    protected ExpiryTimeout(String pushID, boolean isCloudPushID) {
        this.pushID = pushID;
        this.isCloudPushID = isCloudPushID;
    }

    public void run() {
        block4: {
            PushID _pushID;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Expiry timeout occurred for PushID '" + this.getPushID() + "'.");
            }
            if ((_pushID = this.internalPushGroupManager.getPushID(this.getPushID())) != null) {
                try {
                    _pushID.discard();
                    _pushID.cancelExpiryTimeout();
                }
                catch (Exception exception) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block4;
                    LOGGER.log(Level.WARNING, "Exception caught on expiryTimeout TimerTask.", exception);
                }
            }
        }
    }

    protected String getPushID() {
        return this.pushID;
    }

    protected boolean isCloudPushID() {
        return this.isCloudPushID;
    }
}

