/*
 * Decompiled with CFR 0.152.
 */
package org.icepush;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepush.InternalPushGroupManager;
import org.icepush.PushGroupManager;
import org.icepush.PushID;
import org.icepush.PushInternalContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group
implements Serializable {
    private static final long serialVersionUID = -2793842028376415034L;
    private static final Logger LOGGER = Logger.getLogger(Group.class.getName());
    private final long groupTimeout;
    private final String name;
    private final Set<String> pushIDSet = new HashSet<String>();
    private long lastAccess = System.currentTimeMillis();

    protected Group(Group group) {
        this(group.getName(), group.getGroupTimeout());
        this.pushIDSet.addAll(group.getPushIDSet());
        this.lastAccess = group.getLastAccess();
    }

    protected Group(String name, long groupTimeout) {
        this.name = name;
        this.groupTimeout = groupTimeout;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Push Group '" + this.getName() + "' created.");
        }
    }

    public boolean addPushID(String pushID) {
        return this.getPushIDSet().add(pushID);
    }

    public String getName() {
        return this.name;
    }

    public boolean removePushID(String pushID) {
        boolean _modified = this.getPushIDSet().remove(pushID);
        if (this.getPushIDSet().isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Disposed Push Group '" + this.getName() + "' since it no longer contains any PushIDs.");
            }
            ((InternalPushGroupManager)PushInternalContext.getInstance().getAttribute(PushGroupManager.class.getName())).removeGroup(this.getName());
        }
        return _modified;
    }

    public String toString() {
        return "Group[" + this.membersAsString() + "]";
    }

    protected long getGroupTimeout() {
        return this.groupTimeout;
    }

    protected long getLastAccess() {
        return this.lastAccess;
    }

    protected String[] getPushIDs() {
        return this.getPushIDSet().toArray(new String[this.getPushIDSet().size()]);
    }

    protected Set<String> getPushIDSet() {
        return this.pushIDSet;
    }

    protected String membersAsString() {
        return "name: '" + this.getName() + "', " + "pushIDSet: '" + this.getPushIDSet() + "', " + "lastAccess: '" + this.getLastAccess() + "'";
    }

    protected void touch() {
        this.touch(System.currentTimeMillis());
    }

    protected void touch(long timestamp) {
        this.lastAccess = timestamp;
    }

    protected void touchIfMatching(Set<String> pushIDSet) {
        for (String _pushID : pushIDSet) {
            if (!this.getPushIDSet().contains(_pushID)) continue;
            this.touch();
            ((InternalPushGroupManager)PushInternalContext.getInstance().getAttribute(PushGroupManager.class.getName())).groupTouched(this.getName(), this.getLastAccess());
            return;
        }
    }

    void discardIfExpired() {
        if (this.getLastAccess() + this.getGroupTimeout() < System.currentTimeMillis()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Push Group '" + this.getName() + "' expired.");
            }
            ((InternalPushGroupManager)PushInternalContext.getInstance().getAttribute(PushGroupManager.class.getName())).removeGroup(this.getName());
            ((InternalPushGroupManager)PushInternalContext.getInstance().getAttribute(PushGroupManager.class.getName())).removePendingNotifications(this.getPushIDSet());
            for (String _pushIDString : this.getPushIDSet()) {
                PushID _pushID = ((InternalPushGroupManager)PushInternalContext.getInstance().getAttribute(PushGroupManager.class.getName())).getPushID(_pushIDString);
                if (_pushID == null) continue;
                _pushID.removeFromGroup(this.getName());
            }
        }
    }
}

