/*
 * Decompiled with CFR 0.152.
 */
package org.icepush;

import java.util.ArrayList;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepush.NotificationBroadcaster;
import org.icepush.NotificationEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalNotificationBroadcaster
implements NotificationBroadcaster {
    private static final Logger LOGGER = Logger.getLogger(LocalNotificationBroadcaster.class.getName());
    private Set<NotificationBroadcaster.Receiver> receivers = new CopyOnWriteArraySet<NotificationBroadcaster.Receiver>();
    private Timer timer = new Timer(true);

    @Override
    public void addReceiver(NotificationBroadcaster.Receiver receiver) {
        this.receivers.add(receiver);
    }

    @Override
    public void broadcast(Set<NotificationEntry> notificationSet, long duration) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Local Notification Broadcaster broadcasting " + notificationSet);
        }
        ArrayList<NotificationBroadcaster.Receiver> interestedReceivers = new ArrayList<NotificationBroadcaster.Receiver>();
        for (NotificationBroadcaster.Receiver receiver : this.receivers) {
            if (!receiver.isInterested(notificationSet)) continue;
            interestedReceivers.add(receiver);
        }
        if (!interestedReceivers.isEmpty()) {
            long spreadInterval = duration / (long)interestedReceivers.size();
            int index = 0;
            for (NotificationBroadcaster.Receiver receiver : interestedReceivers) {
                this.timer.schedule((TimerTask)new BroadcastTask(receiver, notificationSet), (long)index * spreadInterval);
                ++index;
            }
        }
    }

    @Override
    public void deleteReceiver(NotificationBroadcaster.Receiver observer) {
        this.receivers.remove(observer);
    }

    public void shutdown() {
        this.timer.cancel();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BroadcastTask
    extends TimerTask {
        private final NotificationBroadcaster.Receiver receiver;
        private final Set<NotificationEntry> notificationSet;

        public BroadcastTask(NotificationBroadcaster.Receiver receiver, Set<NotificationEntry> notificationSet) {
            this.receiver = receiver;
            this.notificationSet = notificationSet;
        }

        @Override
        public void run() {
            block2: {
                try {
                    this.receiver.receive(this.notificationSet);
                }
                catch (Exception exception) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block2;
                    LOGGER.log(Level.WARNING, "Exception caught on broadcast task.", exception);
                }
            }
        }
    }
}

