/*
 * Decompiled with CFR 0.152.
 */
package org.icepush;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.icepush.AbstractPushGroupManager;
import org.icepush.BlockingConnectionServer;
import org.icepush.Browser;
import org.icepush.ConfirmationTimeout;
import org.icepush.ExpiryTimeout;
import org.icepush.Group;
import org.icepush.InternalPushGroupManager;
import org.icepush.LocalNotificationBroadcaster;
import org.icepush.NotificationBroadcaster;
import org.icepush.NotificationEntry;
import org.icepush.NotificationProvider;
import org.icepush.NotifyBackURI;
import org.icepush.OutOfBandNotifier;
import org.icepush.PushConfiguration;
import org.icepush.PushGroupManager;
import org.icepush.PushID;
import org.icepush.PushInternalContext;
import org.icepush.PushNotification;
import org.icepush.servlet.ServletContextConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalPushGroupManager
extends AbstractPushGroupManager
implements InternalPushGroupManager,
PushGroupManager {
    private static final Logger LOGGER = Logger.getLogger(LocalPushGroupManager.class.getName());
    private static final String[] STRINGS = new String[0];
    private static final int GROUP_SCANNING_TIME_RESOLUTION = 3000;
    private static final OutOfBandNotifier NOOPOutOfBandNotifier = new OutOfBandNotifier(){

        public void broadcast(PushNotification notification, String[] browserIDs, String groupName) {
            System.out.println("Message send " + notification + " to " + Arrays.asList(browserIDs) + " for " + groupName);
        }

        public void registerProvider(String protocol, NotificationProvider provider) {
        }

        public void trace(String message) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "NOOPOutOfBandNotifier discarding notification " + message);
            }
        }
    };
    private static final Comparator<Notification> ScheduledAtComparator = new Comparator<Notification>(){

        @Override
        public int compare(Notification a, Notification b) {
            return (int)(a.getPushConfiguration().getScheduledAt() - b.getPushConfiguration().getScheduledAt());
        }
    };
    private final Notification NOOP = new Notification("---"){

        public void run() {
        }
    };
    private final Map<String, BlockingConnectionServer> blockingConnectionServerMap = new ConcurrentHashMap<String, BlockingConnectionServer>();
    private final ConcurrentMap<String, Browser> browserMap = new ConcurrentHashMap<String, Browser>();
    private final ConcurrentMap<String, Group> groupMap = new ConcurrentHashMap<String, Group>();
    private final ConcurrentMap<String, PushID> pushIDMap = new ConcurrentHashMap<String, PushID>();
    private final ConcurrentMap<String, ConfirmationTimeout> confirmationTimeoutMap = new ConcurrentHashMap<String, ConfirmationTimeout>();
    private final ConcurrentMap<String, ExpiryTimeout> expiryTimeoutMap = new ConcurrentHashMap<String, ExpiryTimeout>();
    private final ConcurrentMap<String, NotifyBackURI> parkedPushIDs = new ConcurrentHashMap<String, NotifyBackURI>();
    private final ReentrantLock pendingNotifiedPushIDSetLock = new ReentrantLock();
    private final Set<NotificationEntry> pendingNotifiedPushIDSet = new HashSet<NotificationEntry>();
    private final LocalNotificationBroadcaster outboundNotifier = new LocalNotificationBroadcaster();
    private final Timer timer = new Timer("Notification queue consumer.", true);
    private final TimerTask queueConsumer;
    private final BlockingQueue<Notification> queue;
    private final long groupTimeout;
    private final long cloudPushIDTimeout;
    private final long pushIDTimeout;
    private final long minCloudPushInterval;
    private final ServletContext context;
    private long lastTouchScan = System.currentTimeMillis();
    private long lastExpiryScan = System.currentTimeMillis();

    public LocalPushGroupManager(ServletContext servletContext) {
        this.context = servletContext;
        ServletContextConfiguration configuration = new ServletContextConfiguration("org.icepush", servletContext);
        this.groupTimeout = configuration.getAttributeAsLong("groupTimeout", 120000L);
        this.pushIDTimeout = configuration.getAttributeAsLong("pushIdTimeout", 120000L);
        this.cloudPushIDTimeout = configuration.getAttributeAsLong("cloudPushIdTimeout", 1800000L);
        this.minCloudPushInterval = configuration.getAttributeAsLong("minCloudPushInterval", 10000L);
        int notificationQueueSize = configuration.getAttributeAsInteger("notificationQueueSize", 1000);
        this.queue = new LinkedBlockingQueue<Notification>(notificationQueueSize);
        this.queueConsumer = new QueueConsumerTask();
        this.timer.schedule(this.queueConsumer, 0L);
    }

    @Override
    public void addBlockingConnectionServer(String browserID, BlockingConnectionServer server) {
        this.blockingConnectionServerMap.put(browserID, server);
    }

    @Override
    public boolean addBrowser(Browser browser) {
        return this.addBrowser(this.getModifiableBrowserMap(), browser);
    }

    @Override
    public boolean addMember(String groupName, String pushID) {
        return this.addMember(this.getModifiableGroupMap(), this.getModifiablePushIDMap(), groupName, pushID);
    }

    @Override
    public void addNotificationReceiver(NotificationBroadcaster.Receiver observer) {
        this.outboundNotifier.addReceiver(observer);
    }

    @Override
    public void backOff(String browserID, long delay) {
        BlockingConnectionServer server = this.blockingConnectionServerMap.get(browserID);
        if (server != null) {
            server.backOff(delay);
        }
    }

    @Override
    public boolean cancelConfirmationTimeout(String browserID) {
        ConfirmationTimeout confirmationTimeout = this.getConfirmationTimeoutMap().remove(browserID);
        if (confirmationTimeout != null) {
            confirmationTimeout.cancel();
            confirmationTimeout = null;
            this.getBrowser(browserID).setPushConfiguration(null);
            return true;
        }
        return false;
    }

    @Override
    public boolean cancelExpiryTimeout(String pushID) {
        ExpiryTimeout expiryTimeout = this.getExpiryTimeoutMap().remove(pushID);
        if (expiryTimeout != null) {
            expiryTimeout.cancel();
            expiryTimeout = null;
            return true;
        }
        return false;
    }

    @Override
    public void cancelExpiryTimeouts(String browserID) {
        Browser browser = this.getBrowser(browserID);
        for (String pushIDString : browser.getPushIDSet()) {
            PushID pushID = this.getPushIDMap().get(pushIDString);
            if (pushID == null) continue;
            pushID.cancelExpiryTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPendingNotification(String pushID) {
        this.getPendingNotifiedPushIDSetLock().lock();
        try {
            this.clearPendingNotifications(this.getModifiablePendingNotifiedPushIDSet(), pushID);
        }
        finally {
            this.getPendingNotifiedPushIDSetLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPendingNotifications(Set<String> pushIDSet) {
        this.getPendingNotifiedPushIDSetLock().lock();
        try {
            this.clearPendingNotifications(this.getModifiablePendingNotifiedPushIDSet(), pushIDSet);
        }
        finally {
            this.getPendingNotifiedPushIDSetLock().unlock();
        }
    }

    @Override
    public void deleteNotificationReceiver(NotificationBroadcaster.Receiver observer) {
        this.outboundNotifier.deleteReceiver(observer);
    }

    @Override
    public Browser getBrowser(String browserID) {
        if (browserID == null) {
            return null;
        }
        return this.getBrowserMap().get(browserID);
    }

    @Override
    public Map<String, Browser> getBrowserMap() {
        return Collections.unmodifiableMap(this.getModifiableBrowserMap());
    }

    @Override
    public Group getGroup(String groupName) {
        return this.getGroup(this.getModifiableGroupMap(), groupName);
    }

    @Override
    public Map<String, Group> getGroupMap() {
        return Collections.unmodifiableMap(this.getModifiableGroupMap());
    }

    @Override
    public Map<String, String[]> getGroupPushIDsMap() {
        return this.getGroupPushIDsMap(this.getModifiableGroupMap());
    }

    @Override
    public OutOfBandNotifier getOutOfBandNotifier() {
        Object attribute = this.context.getAttribute(OutOfBandNotifier.class.getName());
        return attribute == null ? NOOPOutOfBandNotifier : (OutOfBandNotifier)attribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<NotificationEntry> getPendingNotificationSet() {
        this.getPendingNotifiedPushIDSetLock().lock();
        try {
            HashSet<NotificationEntry> hashSet = new HashSet<NotificationEntry>(this.getPendingNotifiedPushIDSet());
            return hashSet;
        }
        finally {
            this.getPendingNotifiedPushIDSetLock().unlock();
        }
    }

    public Set<NotificationEntry> getPendingNotifiedPushIDSet() {
        return Collections.unmodifiableSet(this.getModifiablePendingNotifiedPushIDSet());
    }

    @Override
    public PushID getPushID(String pushID) {
        return this.getPushIDMap().get(pushID);
    }

    @Override
    public Map<String, PushID> getPushIDMap() {
        return Collections.unmodifiableMap(this.getModifiablePushIDMap());
    }

    @Override
    public boolean isParked(String pushID) {
        return this.parkedPushIDs.containsKey(pushID);
    }

    @Override
    public NotifyBackURI newNotifyBackURI(String uri) {
        return new NotifyBackURI(uri);
    }

    @Override
    public void park(String pushId, NotifyBackURI notifyBackURI) {
        this.parkedPushIDs.put(pushId, notifyBackURI);
    }

    @Override
    public void pruneParkedIDs(NotifyBackURI notifyBackURI, Set<String> listenedPushIDSet) {
        for (Map.Entry parkedPushIDEntry : this.parkedPushIDs.entrySet()) {
            String parkedPushID = (String)parkedPushIDEntry.getKey();
            if (!((NotifyBackURI)parkedPushIDEntry.getValue()).getURI().equals(notifyBackURI.getURI()) || listenedPushIDSet.contains(parkedPushID)) continue;
            this.parkedPushIDs.remove(parkedPushID);
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.log(Level.FINE, "Removed unlistened parked PushID '" + parkedPushID + "' for " + "NotifyBackURI '" + notifyBackURI + "'.");
        }
    }

    @Override
    public void push(String groupName) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Push Notification request for Group '" + groupName + "'.");
        }
        if (!this.queue.offer(this.newNotification(groupName)) && LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "Push Notification request for Group '" + groupName + "' was dropped, " + "queue maximum size reached.");
        }
    }

    @Override
    public void push(String groupName, PushConfiguration pushConfiguration) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Push Notification request for Group '" + groupName + "' " + "(Push Configuration: '" + pushConfiguration + "').");
        }
        Notification notification = this.isOutOfBandNotification(pushConfiguration) ? this.newOutOfBandNotification(groupName, pushConfiguration) : this.newNotification(groupName, pushConfiguration);
        this.queue.add(notification);
    }

    @Override
    public void removeBlockingConnectionServer(String browserID) {
        this.blockingConnectionServerMap.remove(browserID);
    }

    @Override
    public boolean removeBrowser(Browser browser) {
        return this.removeBrowser(this.getModifiableBrowserMap(), browser);
    }

    @Override
    public boolean removeGroup(String groupName) {
        return this.removeGroup(this.getModifiableGroupMap(), groupName);
    }

    @Override
    public boolean removeMember(String groupName, String pushID) {
        return this.removeMember(this.getModifiableGroupMap(), groupName, pushID);
    }

    @Override
    public void removePendingNotification(String pushID) {
        this.clearPendingNotification(pushID);
    }

    @Override
    public void removePendingNotifications(Set<String> pushIDSet) {
        this.clearPendingNotifications(pushIDSet);
    }

    @Override
    public boolean removePushID(String pushID) {
        return this.removePushID(this.getModifiablePushIDMap(), pushID);
    }

    @Override
    public void scan(String[] confirmedPushIDs) {
        this.scan(this.getModifiableGroupMap(), confirmedPushIDs);
    }

    @Override
    public void shutdown() {
        this.outboundNotifier.shutdown();
        this.queueConsumer.cancel();
        this.timer.cancel();
    }

    public void startConfirmationTimeout(Set<NotificationEntry> notificationSet) {
        for (NotificationEntry _notificationEntry : notificationSet) {
            this.startConfirmationTimeout(_notificationEntry);
        }
    }

    @Override
    public boolean startConfirmationTimeout(String browserID, String groupName) {
        return this.startConfirmationTimeout(browserID, groupName, this.getBrowser(browserID).getSequenceNumber());
    }

    @Override
    public boolean startConfirmationTimeout(String browserID, String groupName, long sequenceNumber) {
        Browser browser = this.getBrowser(browserID);
        NotifyBackURI notifyBackURI = browser.getNotifyBackURI();
        if (notifyBackURI != null) {
            long now = System.currentTimeMillis();
            long timeout = browser.getStatus().getConnectionRecreationTimeout() * 2L;
            LOGGER.log(Level.FINE, "Calculated confirmation timeout: '" + timeout + "'");
            if (notifyBackURI.getTimestamp() + browser.getMinCloudPushInterval() <= now + timeout) {
                return this.startConfirmationTimeout(browserID, groupName, sequenceNumber, timeout);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Timeout is within the minimum Cloud Push interval for URI '" + notifyBackURI + "'. (" + "timestamp: '" + notifyBackURI.getTimestamp() + "', " + "minCloudPushInterval: '" + browser.getMinCloudPushInterval() + "', " + "now: '" + now + "', " + "timeout: '" + timeout + "'" + ")");
            }
        }
        return false;
    }

    @Override
    public boolean startConfirmationTimeout(String browserID, String groupName, long sequenceNumber, long timeout) {
        Browser browser = this.getBrowser(browserID);
        NotifyBackURI notifyBackURI = browser.getNotifyBackURI();
        if (notifyBackURI != null && notifyBackURI.getTimestamp() + browser.getMinCloudPushInterval() <= System.currentTimeMillis() + timeout && this.isOutOfBandNotification(browser.getPushConfiguration())) {
            ConfirmationTimeout confirmationTimeout = this.getConfirmationTimeoutMap().get(browserID);
            if (confirmationTimeout == null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Start confirmation timeout for Browser '" + browserID + "' (" + "URI: '" + notifyBackURI + "', " + "timeout: '" + timeout + "', " + "sequence number: '" + sequenceNumber + "'" + ").");
                }
                try {
                    confirmationTimeout = this.newConfirmationTimeout(browserID, groupName, timeout);
                    ((Timer)PushInternalContext.getInstance().getAttribute(Timer.class.getName() + "$confirmation")).schedule((TimerTask)confirmationTimeout, timeout);
                    this.getConfirmationTimeoutMap().put(browserID, confirmationTimeout);
                    return true;
                }
                catch (IllegalStateException exception) {
                    return false;
                }
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Confirmation timeout already scheduled for PushID '" + browserID + "' " + "(URI: '" + notifyBackURI + "', timeout: '" + timeout + "').");
            }
        }
        return false;
    }

    @Override
    public boolean startExpiryTimeout(String pushID) {
        PushID _pushID = this.getPushID(pushID);
        if (_pushID != null) {
            String browserID = this.getPushID(pushID).getBrowserID();
            return this.startExpiryTimeout(pushID, null, browserID != null ? this.getBrowser(browserID).getSequenceNumber() : -1L);
        }
        return this.startExpiryTimeout(pushID, null, -1L);
    }

    @Override
    public boolean startExpiryTimeout(String pushID, String browserID, long sequenceNumber) {
        boolean _isCloudPushID;
        PushID _pushID = this.getPushID(pushID);
        boolean bl = _isCloudPushID = browserID != null && this.getBrowser(browserID).getNotifyBackURI() != null;
        if (!this.getExpiryTimeoutMap().containsKey(pushID)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Start expiry timeout for PushID '" + pushID + "' (" + "timeout: '" + (!_isCloudPushID ? _pushID.getPushIDTimeout() : _pushID.getCloudPushIDTimeout()) + "', " + "sequence number: '" + sequenceNumber + "'" + ").");
            }
            try {
                ExpiryTimeout _expiryTimeout = this.newExpiryTimeout(pushID, _isCloudPushID);
                ((Timer)PushInternalContext.getInstance().getAttribute(Timer.class.getName() + "$expiry")).schedule((TimerTask)_expiryTimeout, !_isCloudPushID ? this.pushIDTimeout : this.cloudPushIDTimeout);
                this.getExpiryTimeoutMap().put(pushID, _expiryTimeout);
                return true;
            }
            catch (IllegalStateException exception) {
                return false;
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Expiry timeout already scheduled for PushID '" + pushID + "' (" + "timeout: '" + (!_isCloudPushID ? _pushID.getPushIDTimeout() : _pushID.getCloudPushIDTimeout()) + "'" + ").");
        }
        return false;
    }

    @Override
    public void startExpiryTimeouts(String browserID) {
        Browser browser = this.getBrowser(browserID);
        for (String pushIDString : browser.getPushIDSet()) {
            PushID pushID = this.getPushID(pushIDString);
            if (pushID == null) continue;
            pushID.startExpiryTimeout(browserID, browser.getSequenceNumber());
        }
    }

    protected boolean addBrowser(Map<String, Browser> browserMap, Browser browser) {
        boolean _modified = false;
        if (!browserMap.containsKey(browser.getID())) {
            browserMap.put(browser.getID(), browser);
            _modified = true;
        }
        return _modified;
    }

    protected boolean addMember(Map<String, Group> groupMap, Map<String, PushID> pushIDMap, String groupName, String pushID) {
        boolean _modified = false;
        if (groupMap != null && pushIDMap != null && groupName != null && pushID != null) {
            PushID _pushID;
            if (pushIDMap.containsKey(pushID)) {
                _pushID = pushIDMap.get(pushID);
            } else {
                _pushID = this.newPushID(pushID);
                pushIDMap.put(pushID, _pushID);
                this.addBrowser(this.newBrowser(_pushID.getBrowserID(), this.getMinCloudPushInterval()));
                _pushID.startExpiryTimeout();
                _modified = true;
            }
            _modified |= _pushID.addToGroup(groupName);
            _modified |= this.addToGroup(groupMap, groupName, pushID);
            this.memberAdded(groupName, pushID);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Added PushID '" + pushID + "' to Push Group '" + groupName + "'.");
            }
        }
        return _modified;
    }

    protected boolean addToGroup(String groupName, String pushID) {
        return this.addToGroup(this.getModifiableGroupMap(), groupName, pushID);
    }

    protected boolean addToGroup(Map<String, Group> groupMap, String groupName, String pushID) {
        Group _group;
        boolean _modified = false;
        if (groupMap.containsKey(groupName)) {
            _group = groupMap.get(groupName);
        } else {
            _group = this.newGroup(groupName);
            groupMap.put(groupName, _group);
            _modified = true;
        }
        return _modified |= _group.addPushID(pushID);
    }

    protected void clearPendingNotifications(Set<NotificationEntry> pendingNotifiedPushIDSet, String pushID) {
        for (NotificationEntry _pendingNotifiedPushID : new HashSet<NotificationEntry>(pendingNotifiedPushIDSet)) {
            if (!_pendingNotifiedPushID.getPushID().equals(pushID)) continue;
            pendingNotifiedPushIDSet.remove(_pendingNotifiedPushID);
        }
    }

    protected void clearPendingNotifications(Set<NotificationEntry> pendingNotifiedPushIDSet, Set<String> pushIDSet) {
        for (NotificationEntry _pendingNotifiedPushID : new HashSet<NotificationEntry>(pendingNotifiedPushIDSet)) {
            if (!pushIDSet.contains(_pendingNotifiedPushID.getPushID())) continue;
            pendingNotifiedPushIDSet.remove(_pendingNotifiedPushID);
        }
    }

    protected long getCloudPushIDTimeout() {
        return this.cloudPushIDTimeout;
    }

    protected Map<String, ConfirmationTimeout> getConfirmationTimeoutMap() {
        return this.confirmationTimeoutMap;
    }

    protected Map<String, ExpiryTimeout> getExpiryTimeoutMap() {
        return this.expiryTimeoutMap;
    }

    protected Group getGroup(Map<String, Group> groupMap, String groupName) {
        return groupMap.get(groupName);
    }

    protected Map<String, String[]> getGroupPushIDsMap(Map<String, Group> groupMap) {
        HashMap<String, String[]> groupPushIDsMap = new HashMap<String, String[]>();
        for (Group group : new ArrayList<Group>(groupMap.values())) {
            groupPushIDsMap.put(group.getName(), group.getPushIDs());
        }
        return groupPushIDsMap;
    }

    protected long getGroupTimeout() {
        return this.groupTimeout;
    }

    protected long getMinCloudPushInterval() {
        return this.minCloudPushInterval;
    }

    protected ConcurrentMap<String, Browser> getModifiableBrowserMap() {
        return this.browserMap;
    }

    protected ConcurrentMap<String, Group> getModifiableGroupMap() {
        return this.groupMap;
    }

    protected Set<NotificationEntry> getModifiablePendingNotifiedPushIDSet() {
        return this.pendingNotifiedPushIDSet;
    }

    protected ConcurrentMap<String, PushID> getModifiablePushIDMap() {
        return this.pushIDMap;
    }

    protected Lock getPendingNotifiedPushIDSetLock() {
        return this.pendingNotifiedPushIDSetLock;
    }

    protected long getPushIDTimeout() {
        return this.pushIDTimeout;
    }

    protected boolean isOutOfBandNotification(PushConfiguration pushConfiguration) {
        return pushConfiguration != null && pushConfiguration.getAttributes().containsKey("subject");
    }

    protected Browser newBrowser(String browserID, long minCloudPushInterval) {
        return new Browser(browserID, minCloudPushInterval);
    }

    protected ConfirmationTimeout newConfirmationTimeout(String browserID, String groupName, long timeout) {
        return new ConfirmationTimeout(browserID, groupName, timeout, this.getBrowser(browserID).getMinCloudPushInterval());
    }

    protected ExpiryTimeout newExpiryTimeout(String pushID, boolean isCloudPushID) {
        return new ExpiryTimeout(pushID, isCloudPushID);
    }

    protected Group newGroup(String name) {
        return new Group(name, this.getGroupTimeout());
    }

    protected Notification newNotification(String groupName) {
        return new Notification(groupName);
    }

    protected Notification newNotification(String groupName, PushConfiguration pushConfiguration) {
        return new Notification(groupName, pushConfiguration);
    }

    protected OutOfBandNotification newOutOfBandNotification(String groupName, PushConfiguration pushConfiguration) {
        return new OutOfBandNotification(groupName, pushConfiguration);
    }

    protected PushID newPushID(String id) {
        return new PushID(id, this.getPushIDTimeout(), this.getCloudPushIDTimeout());
    }

    protected boolean removeBrowser(Map<String, Browser> browserMap, Browser browser) {
        return browserMap.remove(browser.getID()) != null;
    }

    protected boolean removeGroup(Map<String, Group> groupMap, String groupName) {
        return groupMap.remove(groupName) != null;
    }

    protected boolean removeMember(Map<String, Group> groupMap, String groupName, String pushID) {
        Group group;
        boolean _modified = false;
        if (groupMap != null && groupName != null && pushID != null && (group = groupMap.get(groupName)) != null) {
            _modified = group.removePushID(pushID);
            PushID id = (PushID)this.pushIDMap.get(pushID);
            if (id != null) {
                _modified |= id.removeFromGroup(groupName);
            }
            this.memberRemoved(groupName, pushID);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Removed PushID '" + pushID + "' from Push Group '" + groupName + "'.");
            }
        }
        return _modified;
    }

    protected boolean removePushID(Map<String, PushID> pushIDMap, String pushID) {
        return pushIDMap.remove(pushID) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scan(Map<String, Group> groupMap, String[] confirmedPushIDs) {
        HashSet<String> pushIDSet = new HashSet<String>(Arrays.asList(confirmedPushIDs));
        long now = System.currentTimeMillis();
        for (Group group : groupMap.values()) {
            group.touchIfMatching(pushIDSet);
        }
        if (this.lastTouchScan + 3000L < now) {
            try {
                for (Group group : groupMap.values()) {
                    group.discardIfExpired();
                }
            }
            finally {
                this.lastTouchScan = now;
                this.lastExpiryScan = now;
            }
        }
    }

    protected void scanForExpiry() {
        this.scanForExpiry(this.getModifiableGroupMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scanForExpiry(Map<String, Group> groupMap) {
        long now = System.currentTimeMillis();
        if (this.lastExpiryScan + 3000L < now) {
            try {
                for (Group group : groupMap.values()) {
                    group.discardIfExpired();
                }
            }
            finally {
                this.lastExpiryScan = now;
            }
        }
    }

    protected void startConfirmationTimeout(NotificationEntry notificationEntry) {
        Browser _browser;
        PushID _pushID = this.getPushID(notificationEntry.getPushID());
        if (_pushID != null && (_browser = this.getBrowser(_pushID.getBrowserID())) != null) {
            _browser.startConfirmationTimeout(notificationEntry.getGroupName());
        }
    }

    private class QueueConsumerTask
    extends TimerTask {
        private boolean running = true;

        private QueueConsumerTask() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (this.running) {
                    try {
                        long currentTime = System.currentTimeMillis();
                        Notification notification = (Notification)LocalPushGroupManager.this.queue.take();
                        LocalPushGroupManager.this.queue.offer(notification);
                        TreeSet notifications = new TreeSet(ScheduledAtComparator);
                        notifications.addAll(LocalPushGroupManager.this.queue);
                        Notification scheduledNotification = (Notification)notifications.first();
                        long scheduledAt = scheduledNotification.getPushConfiguration().getScheduledAt();
                        if (scheduledAt >= currentTime) continue;
                        LocalPushGroupManager.this.queue.remove(scheduledNotification);
                        long duration = scheduledNotification.getPushConfiguration().getDuration();
                        long endOfScheduledNotification = scheduledAt + duration;
                        for (Notification nextScheduledNotification : notifications) {
                            if (nextScheduledNotification == scheduledNotification) continue;
                            if (endOfScheduledNotification <= nextScheduledNotification.getPushConfiguration().getScheduledAt()) break;
                            scheduledNotification.coalesceWith(nextScheduledNotification);
                        }
                        scheduledNotification.run();
                    }
                    catch (Throwable t) {
                        LOGGER.log(Level.WARNING, "Notification queue encountered ", t);
                    }
                }
                return;
            }
            catch (Exception exception) {
                if (!LOGGER.isLoggable(Level.WARNING)) return;
                LOGGER.log(Level.WARNING, "Exception caught on " + this.getClass().getName() + " TimerTask.", exception);
            }
        }

        public boolean cancel() {
            this.running = false;
            LocalPushGroupManager.this.queue.offer(LocalPushGroupManager.this.NOOP);
            return super.cancel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class OutOfBandNotification
    extends Notification
    implements Runnable {
        protected OutOfBandNotification(String groupName, PushConfiguration pushConfiguration) {
            super(groupName, pushConfiguration);
        }

        @Override
        protected void beforeBroadcast(Set<NotificationEntry> notificationEntrySet) {
            LocalPushGroupManager.this.startConfirmationTimeout(notificationEntrySet);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Notification
    implements Runnable {
        protected final String groupName;
        protected final Set<String> exemptPushIDSet = new HashSet<String>();
        protected PushConfiguration pushConfiguration;

        protected Notification(String groupName) {
            this(groupName, new PushConfiguration());
        }

        protected Notification(String groupName, PushConfiguration pushConfiguration) {
            this.groupName = groupName;
            this.pushConfiguration = pushConfiguration;
            Set pushIDSet = (Set)this.pushConfiguration.getAttributes().get("pushIDSet");
            if (pushIDSet != null) {
                this.exemptPushIDSet.addAll(pushIDSet);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block11: {
                try {
                    Group group = (Group)LocalPushGroupManager.this.getModifiableGroupMap().get(this.groupName);
                    if (group == null) break block11;
                    HashSet<String> pushIDSet = new HashSet<String>(Arrays.asList(group.getPushIDs()));
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Notification triggered for Group '" + this.groupName + "' with " + "original Push-ID Set '" + pushIDSet + "'.");
                    }
                    pushIDSet.removeAll(this.exemptPushIDSet);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Notification triggered for Group '" + this.groupName + "' with " + "Push-ID Set '" + pushIDSet + "' after exemption.");
                    }
                    HashSet<NotificationEntry> notificationEntrySet = new HashSet<NotificationEntry>();
                    for (String pushID : pushIDSet) {
                        notificationEntrySet.add(this.newNotificationEntry(pushID, this.groupName));
                    }
                    this.filterNotificationEntrySet(notificationEntrySet);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Notification triggered for Group '" + this.groupName + "' with " + "Notification Entry Set '" + notificationEntrySet + "' after filtering.");
                    }
                    for (NotificationEntry notificationEntry : notificationEntrySet) {
                        Browser browser = LocalPushGroupManager.this.getBrowser(LocalPushGroupManager.this.getPushID(notificationEntry.getPushID()).getBrowserID());
                        if (browser == null) continue;
                        browser.setPushConfiguration(this.getPushConfiguration());
                    }
                    LocalPushGroupManager.this.getPendingNotifiedPushIDSetLock().lock();
                    try {
                        LocalPushGroupManager.this.getModifiablePendingNotifiedPushIDSet().addAll(notificationEntrySet);
                    }
                    finally {
                        LocalPushGroupManager.this.getPendingNotifiedPushIDSetLock().unlock();
                    }
                    this.beforeBroadcast(notificationEntrySet);
                    LocalPushGroupManager.this.outboundNotifier.broadcast(notificationEntrySet, this.getPushConfiguration().getDuration());
                    LocalPushGroupManager.this.pushed(this.groupName);
                }
                finally {
                    LocalPushGroupManager.this.scanForExpiry();
                }
            }
        }

        public void coalesceWith(Notification nextNotification) {
            Group group = (Group)LocalPushGroupManager.this.getModifiableGroupMap().get(this.groupName);
            if (group != null) {
                nextNotification.exemptPushIDSet.addAll(Arrays.asList(group.getPushIDs()));
            }
        }

        protected void beforeBroadcast(Set<NotificationEntry> notificationEntrySet) {
        }

        protected void filterNotificationEntrySet(Set<NotificationEntry> notificationEntrySet) {
        }

        protected PushConfiguration getPushConfiguration() {
            return this.pushConfiguration;
        }

        protected NotificationEntry newNotificationEntry(String pushID, String groupName) {
            return new NotificationEntry(pushID, groupName);
        }
    }
}

