/*
 * Decompiled with CFR 0.152.
 */
package org.icepush;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepush.NotificationEntry;
import org.icepush.http.PushResponse;
import org.icepush.http.PushResponseHandler;
import org.icepush.http.standard.FixedXMLContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotifiedPushIDs
extends FixedXMLContentHandler
implements PushResponseHandler {
    private static final Logger LOGGER = Logger.getLogger(NotifiedPushIDs.class.getName());
    private final Set<String> pushIDSet;

    public NotifiedPushIDs(Set<NotificationEntry> notificationEntrySet) {
        HashSet<String> _pushIDSet = new HashSet<String>();
        for (NotificationEntry _notificationEntry : notificationEntrySet) {
            _pushIDSet.add(_notificationEntry.getPushID());
        }
        this.pushIDSet = Collections.unmodifiableSet(_pushIDSet);
    }

    @Override
    public void respond(PushResponse pushResponse) throws Exception {
        super.respond(pushResponse);
    }

    @Override
    public void writeTo(Writer writer) throws IOException {
        writer.write("<notified-pushids>");
        boolean first = true;
        for (String pushID : this.pushIDSet) {
            if (!first) {
                writer.write(32);
            }
            writer.write(pushID);
            first = false;
        }
        writer.write("</notified-pushids>");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Sending Notified PushIDs '" + this.pushIDSet + "'.");
        }
    }

    protected Set<String> getPushIDSet() {
        return this.pushIDSet;
    }
}

