/*
 * Decompiled with CFR 0.152.
 */
package org.icepush;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepush.client.AddGroupMemberRequest;
import org.icepush.client.CreatePushIdRequest;
import org.icepush.client.HttpClient;
import org.icepush.client.HttpRequest;
import org.icepush.client.HttpResponse;
import org.icepush.client.ListenRequest;
import org.icepush.client.NotifyRequest;
import org.icepush.client.PushClientException;
import org.icepush.client.RemoveGroupMemberRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class PushClient {
    private static final Logger LOGGER = Logger.getLogger(PushClient.class.getName());
    private final HttpClient client = new HttpClient();
    private final Map<String, List<Runnable>> pushIdCallbackMap = new HashMap<String, List<Runnable>>();
    private final ReentrantLock listenRequestLock = new ReentrantLock();
    private ListenRequest listenRequest;
    private final String contextURI;

    public PushClient(String contextURI) {
        this.contextURI = contextURI;
    }

    public void addGroupMember(String groupName, String pushId) throws PushClientException {
        try {
            this.sendNow(new AddGroupMemberRequest(groupName, pushId, this.contextURI));
        }
        catch (URISyntaxException exception) {
            throw new PushClientException(exception);
        }
    }

    public String createPushId() throws PushClientException {
        try {
            CreatePushIdRequest _request = new CreatePushIdRequest(this.contextURI);
            this.sendNow(_request);
            return _request.getResponse().getEntityBodyAsString();
        }
        catch (URISyntaxException exception) {
            throw new PushClientException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(String pushId) {
        Map<String, List<Runnable>> map = this.pushIdCallbackMap;
        synchronized (map) {
            this.pushIdCallbackMap.remove(pushId);
            this.listenRequestLock.lock();
            try {
                this.cancelListenRequest();
                if (this.pushIdCallbackMap.keySet().size() > 0) {
                    this.listen();
                }
            }
            finally {
                this.listenRequestLock.unlock();
            }
        }
    }

    public void notify(String groupName) throws PushClientException {
        try {
            this.sendNow(new NotifyRequest(groupName, this.contextURI));
        }
        catch (URISyntaxException exception) {
            throw new PushClientException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String pushId, Runnable callback) {
        Map<String, List<Runnable>> map = this.pushIdCallbackMap;
        synchronized (map) {
            if (this.pushIdCallbackMap.containsKey(pushId)) {
                this.pushIdCallbackMap.get(pushId).add(callback);
            } else {
                ArrayList<Runnable> _callbackList = new ArrayList<Runnable>();
                _callbackList.add(callback);
                this.pushIdCallbackMap.put(pushId, _callbackList);
                this.listenRequestLock.lock();
                try {
                    this.cancelListenRequest();
                    this.listen();
                }
                finally {
                    this.listenRequestLock.unlock();
                }
            }
        }
    }

    public void removeGroupMember(String groupName, String pushId) throws PushClientException {
        try {
            this.sendNow(new RemoveGroupMemberRequest(groupName, pushId, this.contextURI));
        }
        catch (URISyntaxException exception) {
            throw new PushClientException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.listenRequestLock.lock();
        try {
            this.cancelListenRequest();
            this.client.shutdown();
        }
        finally {
            this.listenRequestLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelListenRequest() {
        if (this.listenRequest != null) {
            this.listenRequestLock.lock();
            try {
                if (this.listenRequest != null) {
                    this.client.cancel(this.listenRequest);
                    this.listenRequest = null;
                }
            }
            finally {
                this.listenRequestLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listen() {
        this.listenRequestLock.lock();
        try {
            this.cancelListenRequest();
            Set<String> _pushIdSet = this.pushIdCallbackMap.keySet();
            if (!_pushIdSet.isEmpty()) {
                try {
                    this.listenRequest = new ListenRequest(_pushIdSet, this.contextURI){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onResponse(HttpResponse response) {
                            super.onResponse(response);
                            Document _document = response.getEntityBodyAsDocument();
                            if (_document != null) {
                                Node _currentNode = _document.getFirstChild();
                                String _currentNodeName = _currentNode.getNodeName();
                                if (!_currentNodeName.equalsIgnoreCase("noop") && _currentNodeName.equalsIgnoreCase("notified-pushids")) {
                                    StringTokenizer _pushIds = new StringTokenizer(_currentNode.getFirstChild().getNodeValue());
                                    Map map = PushClient.this.pushIdCallbackMap;
                                    synchronized (map) {
                                        while (_pushIds.hasMoreTokens()) {
                                            String _pushId = _pushIds.nextToken();
                                            if (!PushClient.this.pushIdCallbackMap.containsKey(_pushId)) continue;
                                            for (Runnable _callback : (List)PushClient.this.pushIdCallbackMap.get(_pushId)) {
                                                _callback.run();
                                            }
                                        }
                                    }
                                }
                                if (LOGGER.isLoggable(Level.INFO)) {
                                    LOGGER.log(Level.INFO, "Initiating listen.icepush...");
                                }
                                PushClient.this.listen();
                            }
                        }
                    };
                    this.client.send(this.listenRequest);
                }
                catch (URISyntaxException exception) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, "", exception);
                    }
                }
            }
        }
        finally {
            this.listenRequestLock.unlock();
        }
    }

    private void sendNow(HttpRequest request) throws PushClientException {
        try {
            this.client.sendNow(request);
        }
        catch (MalformedURLException exception) {
            throw new PushClientException(exception);
        }
        catch (IOException exception) {
            throw new PushClientException(exception);
        }
    }
}

