/*
 * Decompiled with CFR 0.152.
 */
package org.icepush;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushConfiguration
implements Serializable {
    private static final long serialVersionUID = -5770414701296818792L;
    private static final Logger LOGGER = Logger.getLogger(PushConfiguration.class.getName());
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private long scheduledAt = System.currentTimeMillis();
    private long duration = 0L;

    public PushConfiguration() {
        this.attributes = new HashMap<String, Object>();
    }

    public PushConfiguration(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public PushConfiguration delayed(long delay, long duration) {
        this.scheduledAt = System.currentTimeMillis() + delay;
        this.duration = duration;
        return this;
    }

    public boolean equals(Object object) {
        return object instanceof PushConfiguration && ((Object)((PushConfiguration)object).attributes).equals(this.attributes) && ((PushConfiguration)object).duration == this.duration && ((PushConfiguration)object).scheduledAt == this.scheduledAt;
    }

    public PushConfiguration scheduled(Date time, long duration) {
        this.scheduledAt = time.getTime();
        this.duration = duration;
        return this;
    }

    public long getScheduledAt() {
        return this.scheduledAt;
    }

    public long getDuration() {
        return this.duration;
    }

    public String toString() {
        return "PushConfiguration[" + "attributes: '" + this.getAttributes() + "', " + "duration: '" + this.getDuration() + "', " + "scheduledAt: '" + new Date(this.getScheduledAt()) + "'" + "]";
    }
}

