/*
 * Decompiled with CFR 0.152.
 */
package org.icepush;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.icepush.Browser;
import org.icepush.PushConfiguration;
import org.icepush.PushGroupManager;
import org.icepush.PushInternalContext;

public class PushContext {
    private static final Logger LOGGER = Logger.getLogger(PushContext.class.getName());
    private int subCounter = 0;

    private PushContext() {
    }

    public void backOff(String browserID, long delay) {
        ((PushGroupManager)PushInternalContext.getInstance().getAttribute(PushGroupManager.class.getName())).backOff(browserID, delay);
    }

    public synchronized String createPushId(HttpServletRequest request, HttpServletResponse response) {
        String browserID = Browser.getBrowserID(request);
        if (browserID == null) {
            String currentBrowserID = (String)request.getAttribute("ice.push.browser");
            if (null == currentBrowserID) {
                browserID = Browser.generateBrowserID();
                Cookie cookie = new Cookie("ice.push.browser", browserID);
                cookie.setPath("/");
                response.addCookie(cookie);
                request.setAttribute("ice.push.browser", (Object)browserID);
            } else {
                browserID = currentBrowserID;
            }
        }
        String id = browserID + ":" + this.generateSubID();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Created new pushId '" + id + "'.");
        }
        return id;
    }

    public void push(String groupName) {
        ((PushGroupManager)PushInternalContext.getInstance().getAttribute(PushGroupManager.class.getName())).push(groupName);
    }

    public void push(String groupName, PushConfiguration config) {
        ((PushGroupManager)PushInternalContext.getInstance().getAttribute(PushGroupManager.class.getName())).push(groupName, config);
    }

    public void addGroupMember(String groupName, String pushId) {
        ((PushGroupManager)PushInternalContext.getInstance().getAttribute(PushGroupManager.class.getName())).addMember(groupName, pushId);
    }

    public void removeGroupMember(String groupName, String pushId) {
        ((PushGroupManager)PushInternalContext.getInstance().getAttribute(PushGroupManager.class.getName())).removeMember(groupName, pushId);
    }

    public static synchronized PushContext getInstance(ServletContext servletContext) {
        PushContext pushContext = (PushContext)servletContext.getAttribute(PushContext.class.getName());
        if (pushContext == null) {
            pushContext = new PushContext();
            servletContext.setAttribute(PushContext.class.getName(), (Object)pushContext);
        }
        return pushContext;
    }

    private synchronized String generateSubID() {
        return Integer.toString(++this.subCounter + this.hashCode() / 10000, 36);
    }
}

