/*
 * Decompiled with CFR 0.152.
 */
package org.icepush;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepush.Group;
import org.icepush.InternalPushGroupManager;
import org.icepush.PushGroupManager;
import org.icepush.PushInternalContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushID
implements Serializable {
    private static final long serialVersionUID = 2845881329862716766L;
    private static final Logger LOGGER = Logger.getLogger(PushID.class.getName());
    private final Set<String> groupSet = new HashSet<String>();
    private final String pushID;
    private final String browserID;
    private final String subID;
    private final long cloudPushIDTimeout;
    private final long pushIDTimeout;

    protected PushID(String pushID, long pushIDTimeout, long cloudPushIDTimeout) {
        this.pushID = pushID;
        this.browserID = this.pushID.substring(0, this.pushID.indexOf(58));
        this.subID = this.pushID.substring(this.pushID.indexOf(58) + 1);
        this.pushIDTimeout = pushIDTimeout;
        this.cloudPushIDTimeout = cloudPushIDTimeout;
    }

    public boolean addToGroup(String groupName) {
        return this.groupSet.add(groupName);
    }

    public boolean cancelExpiryTimeout() {
        return ((InternalPushGroupManager)PushInternalContext.getInstance().getAttribute(PushGroupManager.class.getName())).cancelExpiryTimeout(this.getID());
    }

    public void discard() {
        if (!((InternalPushGroupManager)PushInternalContext.getInstance().getAttribute(PushGroupManager.class.getName())).isParked(this.getID())) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "PushID '" + this.getID() + "' discarded.");
            }
            ((InternalPushGroupManager)PushInternalContext.getInstance().getAttribute(PushGroupManager.class.getName())).removePushID(this.getID());
            ((InternalPushGroupManager)PushInternalContext.getInstance().getAttribute(PushGroupManager.class.getName())).removePendingNotification(this.getID());
            for (String groupName : this.getGroupSet()) {
                Group group = ((InternalPushGroupManager)PushInternalContext.getInstance().getAttribute(PushGroupManager.class.getName())).getGroup(groupName);
                if (group == null) continue;
                group.removePushID(this.getID());
            }
        }
    }

    public String getBrowserID() {
        return this.browserID;
    }

    public String getID() {
        return this.pushID;
    }

    public String getSubID() {
        return this.subID;
    }

    public boolean removeFromGroup(String groupName) {
        boolean _modified = this.groupSet.remove(groupName);
        if (this.groupSet.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Disposed PushID '" + this.getID() + "' since it no longer belongs to any Push Group.");
            }
            ((InternalPushGroupManager)PushInternalContext.getInstance().getAttribute(PushGroupManager.class.getName())).removePushID(this.getID());
        }
        return _modified;
    }

    public boolean startExpiryTimeout() {
        return ((InternalPushGroupManager)PushInternalContext.getInstance().getAttribute(PushGroupManager.class.getName())).startExpiryTimeout(this.getID());
    }

    public boolean startExpiryTimeout(String browserID, long sequenceNumber) {
        return ((InternalPushGroupManager)PushInternalContext.getInstance().getAttribute(PushGroupManager.class.getName())).startExpiryTimeout(this.getID(), browserID, sequenceNumber);
    }

    public String toString() {
        return "PushID[" + this.membersAsString() + "]";
    }

    protected long getCloudPushIDTimeout() {
        return this.cloudPushIDTimeout;
    }

    protected Set<String> getGroupSet() {
        return this.groupSet;
    }

    protected long getPushIDTimeout() {
        return this.pushIDTimeout;
    }

    protected String membersAsString() {
        return "browserID: '" + this.getBrowserID() + ", " + "cloudPushIDTimeout: '" + this.getCloudPushIDTimeout() + "', " + "groupSet: '" + this.getGroupSet() + "', " + "pushID: '" + this.getID() + "', " + "pushIDTimeout: '" + this.getPushIDTimeout() + "', " + "subID: '" + this.getSubID() + "'";
    }
}

