/*
 * Decompiled with CFR 0.152.
 */
package org.icepush;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.icepush.NoopPushGroupManager;
import org.icepush.PushGroupManager;

public class PushInternalContext {
    private static final Logger LOGGER = Logger.getLogger(PushInternalContext.class.getName());
    private static final ReentrantLock INSTANCE_LOCK = new ReentrantLock();
    private static PushInternalContext instance;
    private final ConcurrentMap<String, Object> attributeMap = new ConcurrentHashMap<String, Object>();

    private PushInternalContext() {
        this.setAttribute(PushGroupManager.class.getName(), NoopPushGroupManager.Instance);
    }

    public Object getAttribute(String name) {
        return this.attributeMap.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PushInternalContext getInstance() {
        INSTANCE_LOCK.lock();
        try {
            if (instance == null) {
                instance = new PushInternalContext();
            }
            PushInternalContext pushInternalContext = instance;
            return pushInternalContext;
        }
        finally {
            INSTANCE_LOCK.unlock();
        }
    }

    public void removeAttribute(String name) {
        this.attributeMap.remove(name);
    }

    public void setAttribute(String name, Object object) {
        this.attributeMap.put(name, object);
    }
}

