/*
 * Decompiled with CFR 0.152.
 */
package org.icepush;

import java.util.logging.Logger;
import org.icepush.BackOff;
import org.icepush.Configuration;
import org.icepush.ConfigurationException;
import org.icepush.ConnectionClose;
import org.icepush.http.PushRequest;
import org.icepush.http.PushServer;

public class PushStormDetectionServer
implements PushServer {
    private static final Logger LOGGER = Logger.getLogger(PushStormDetectionServer.class.getName());
    private static final long DefaultLoopInterval = 700L;
    private static final long DefaultMaxTightLoopRequests = 25L;
    private final PushServer pushServer;
    private long backOffInterval;
    private long lastTimeAccess = System.currentTimeMillis();
    private int successiveTightLoopRequests = 0;
    private long loopInterval;
    private long maxTightLoopRequests;

    public PushStormDetectionServer(PushServer pushServer, Configuration configuration) {
        this.pushServer = pushServer;
        this.loopInterval = configuration.getAttributeAsLong("notificationStormLoopInterval", 700L);
        this.maxTightLoopRequests = configuration.getAttributeAsLong("notificationStormMaximumRequests", 25L);
        try {
            this.backOffInterval = configuration.getAttributeAsLong("notificationStormBackOffInterval");
        }
        catch (ConfigurationException e) {
            this.backOffInterval = -1L;
        }
    }

    public void service(PushRequest pushRequest) throws Exception {
        this.successiveTightLoopRequests = System.currentTimeMillis() - this.lastTimeAccess < this.loopInterval ? ++this.successiveTightLoopRequests : 0;
        this.lastTimeAccess = System.currentTimeMillis();
        if ((long)this.successiveTightLoopRequests > this.maxTightLoopRequests) {
            if (this.backOffInterval == -1L) {
                pushRequest.respondWith(new ConnectionClose("push storm occurred"));
            } else {
                pushRequest.respondWith(new BackOff(this.backOffInterval));
            }
        } else {
            this.pushServer.service(pushRequest);
        }
    }

    public void shutdown() {
        this.pushServer.shutdown();
    }
}

