/*
 * Decompiled with CFR 0.152.
 */
package org.icepush;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.icepush.servlet.PseudoServlet;

public class RemoveParameterPrefix
implements PseudoServlet {
    private PseudoServlet servlet;

    public RemoveParameterPrefix(PseudoServlet servlet) {
        this.servlet = servlet;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.servlet.service((HttpServletRequest)new RemoveParameterPrefixRequest(request), response);
    }

    public void shutdown() {
        this.servlet.shutdown();
    }

    private static String extractParameterPrefix(HttpServletRequest request) {
        Enumeration e = request.getParameterNames();
        String parameterPrefix = "";
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.contains("ice.push.browser")) continue;
            parameterPrefix = name.substring(0, name.indexOf("ice.push.browser"));
            break;
        }
        return parameterPrefix;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RemoveParameterPrefixRequest
    extends HttpServletRequestWrapper {
        private final String parameterPrefix;

        public RemoveParameterPrefixRequest(HttpServletRequest request) {
            super(request);
            this.parameterPrefix = RemoveParameterPrefix.extractParameterPrefix(request);
        }

        public String getParameter(String name) {
            return super.getParameter(this.parameterPrefix + name);
        }

        public Map<String, String[]> getParameterMap() {
            HashMap<String, String[]> result = new HashMap<String, String[]>();
            int length = this.parameterPrefix.length();
            for (Map.Entry next : super.getParameterMap().entrySet()) {
                String name = (String)next.getKey();
                String originalParameterName = name.substring(0, length);
                result.put(originalParameterName, (String[])next.getValue());
            }
            return result;
        }

        public Enumeration<String> getParameterNames() {
            ArrayList<String> result = new ArrayList<String>();
            int length = this.parameterPrefix.length();
            Enumeration entries = super.getParameterNames();
            while (entries.hasMoreElements()) {
                String name = (String)entries.nextElement();
                String originalParameterName = name.substring(0, length);
                result.add(originalParameterName);
            }
            return Collections.enumeration(result);
        }

        public String[] getParameterValues(String name) {
            return super.getParameterValues(this.parameterPrefix + name);
        }
    }
}

