/*
 * Decompiled with CFR 0.152.
 */
package org.icepush;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepush.http.PushRequest;
import org.icepush.http.PushResponse;
import org.icepush.http.PushResponseHandler;
import org.icepush.http.PushServer;
import org.icepush.http.standard.PushRequestProxy;
import org.icepush.util.Slot;

public class SequenceTaggingServer
implements PushServer {
    private static final Logger LOGGER = Logger.getLogger(SequenceTaggingServer.class.getName());
    private final PushServer pushServer;
    private Slot sequenceNo;
    private Set<String> participatingPushIDList = new HashSet<String>();
    private boolean participatingPushIDsChanged;

    public SequenceTaggingServer(Slot sequenceNo, PushServer pushServer) {
        this.sequenceNo = sequenceNo;
        this.pushServer = pushServer;
    }

    public void service(PushRequest pushRequest) throws Exception {
        HashSet<String> currentParticipatingPushIDList = new HashSet<String>(pushRequest.getPushIDSet());
        boolean bl = this.participatingPushIDsChanged = !this.participatingPushIDList.containsAll(currentParticipatingPushIDList) || !currentParticipatingPushIDList.containsAll(this.participatingPushIDList);
        if (this.participatingPushIDsChanged) {
            this.participatingPushIDList = currentParticipatingPushIDList;
        }
        this.pushServer.service(new TaggingRequest(pushRequest));
    }

    public void shutdown() {
        this.pushServer.shutdown();
    }

    public class TaggingRequest
    extends PushRequestProxy {
        public TaggingRequest(PushRequest pushRequest) {
            super(pushRequest);
        }

        public void respondWith(PushResponseHandler handler) throws Exception {
            this.getPushRequest().respondWith(new TaggingResponseHandler(handler));
        }

        private class TaggingResponseHandler
        implements PushResponseHandler {
            private final PushResponseHandler handler;

            public TaggingResponseHandler(PushResponseHandler handler) {
                this.handler = handler;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void respond(PushResponse pushResponse) throws Exception {
                try {
                    try {
                        long previousSequenceNo = TaggingRequest.this.getPushRequest().getSequenceNumber();
                        if (previousSequenceNo >= SequenceTaggingServer.this.sequenceNo.getLongValue()) {
                            SequenceTaggingServer.this.sequenceNo.setLongValue(previousSequenceNo + 1L);
                        } else if (SequenceTaggingServer.this.participatingPushIDsChanged) {
                            SequenceTaggingServer.this.sequenceNo.setLongValue(SequenceTaggingServer.this.sequenceNo.getLongValue() + 1L);
                        } else {
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.log(Level.FINE, "Request's 'ice.push.sequence' [" + previousSequenceNo + "] is less than " + "the server-side sequence number [" + SequenceTaggingServer.this.sequenceNo.getLongValue() + "].");
                            }
                            SequenceTaggingServer.this.sequenceNo.setLongValue(SequenceTaggingServer.this.sequenceNo.getLongValue() + 1L);
                        }
                    }
                    catch (RuntimeException e) {
                        if (SequenceTaggingServer.this.sequenceNo.getLongValue() == 0L) {
                            SequenceTaggingServer.this.sequenceNo.setLongValue(1L);
                        }
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "Request's 'ice.push.sequence' header is missing, while server-side sequence number is '" + SequenceTaggingServer.this.sequenceNo.getLongValue() + "'.");
                        }
                        SequenceTaggingServer.this.sequenceNo.setLongValue(SequenceTaggingServer.this.sequenceNo.getLongValue() + 1L);
                    }
                    pushResponse.setSequenceNumber(SequenceTaggingServer.this.sequenceNo.getLongValue());
                }
                finally {
                    this.handler.respond(pushResponse);
                }
            }
        }
    }
}

