/*
 * Decompiled with CFR 0.152.
 */
package org.icepush.client;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepush.client.Cookie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieHandler
extends java.net.CookieHandler {
    private static final Logger LOGGER = Logger.getLogger(CookieHandler.class.getName());
    private final Map<URI, List<Cookie>> cookieMap = new HashMap<URI, List<Cookie>>();

    public void clear() {
        this.cookieMap.clear();
    }

    @Override
    public Map<String, List<String>> get(URI requestURI, Map<String, List<String>> requestHeaders) throws IOException {
        HashMap _cookieMap = new HashMap();
        String _requestURI = requestURI.toString();
        ArrayList<String> _cookieList = new ArrayList<String>();
        for (Map.Entry<URI, List<Cookie>> _entry : this.cookieMap.entrySet()) {
            if (!_requestURI.startsWith(_entry.getKey().toString())) continue;
            for (Cookie _cookie : _entry.getValue()) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "Adding Cookie: " + _cookie.getName() + "=" + _cookie.getValue());
                }
                _cookieList.add(_cookie.getName() + "=" + _cookie.getValue());
            }
        }
        _cookieMap.put("Cookie", _cookieList);
        return Collections.unmodifiableMap(_cookieMap);
    }

    @Override
    public void put(URI requestURI, Map<String, List<String>> responseHeaders) throws IOException {
        for (Map.Entry<String, List<String>> _entry : responseHeaders.entrySet()) {
            String _key = _entry.getKey();
            if (_key == null || !_key.equalsIgnoreCase("Set-Cookie")) continue;
            for (String _value : _entry.getValue()) {
                URI _resolvedURI;
                Cookie _cookie = new Cookie(_value);
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "Caching Cookie: " + _cookie.getName() + "=" + _cookie.getValue() + "; " + _cookie.getPath());
                }
                if (this.cookieMap.containsKey(_resolvedURI = requestURI.resolve(_cookie.getPath()))) {
                    this.cookieMap.get(_resolvedURI).add(_cookie);
                    continue;
                }
                ArrayList<Cookie> _cookieList = new ArrayList<Cookie>();
                _cookieList.add(_cookie);
                this.cookieMap.put(_resolvedURI, _cookieList);
            }
        }
    }
}

