/*
 * Decompiled with CFR 0.152.
 */
package org.icepush.client;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepush.client.CookieHandler;
import org.icepush.client.HttpConnection;
import org.icepush.client.HttpRequest;
import org.icepush.client.ObjectPool;
import org.icepush.util.ThreadFactory;

public class HttpClient {
    private static final Logger LOGGER = Logger.getLogger(HttpClient.class.getName());
    private final ReentrantLock lock = new ReentrantLock();
    private final ObjectPool<HttpConnection> connectionPool = new ObjectPool<HttpConnection>(2){

        @Override
        protected HttpConnection newObject() {
            return new HttpConnection(HttpClient.this.cookieHandler);
        }
    };
    private final CookieHandler cookieHandler;
    private final Map<HttpRequest, ScheduledFuture> pendingRequestMap = new HashMap<HttpRequest, ScheduledFuture>();
    private final Map<HttpRequest, HttpConnection> connectionMap = new HashMap<HttpRequest, HttpConnection>();
    private final ScheduledExecutorService scheduledExecutorService;
    private boolean shutdown;

    public HttpClient() {
        this(new CookieHandler());
    }

    public HttpClient(CookieHandler cookieHandler) {
        ThreadFactory _threadFactory = new ThreadFactory();
        _threadFactory.setDaemon(false);
        _threadFactory.setPrefix("HTTP Client");
        this.scheduledExecutorService = new ScheduledThreadPoolExecutor(2, _threadFactory);
        this.shutdown = false;
        this.cookieHandler = cookieHandler;
        System.setProperty("http.maxConnections", "2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(HttpRequest request) {
        if (!this.shutdown) {
            this.lock.lock();
            try {
                if (!this.shutdown && this.pendingRequestMap.containsKey(request)) {
                    this.pendingRequestMap.remove(request).cancel(true);
                    if (this.connectionMap.containsKey(request)) {
                        HttpConnection _connection = this.connectionMap.remove(request);
                        _connection.close();
                        this.connectionPool.invalidateObject(_connection);
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(final HttpRequest request) {
        if (!this.shutdown) {
            this.lock.lock();
            try {
                if (!this.shutdown) {
                    this.pendingRequestMap.put(request, this.scheduledExecutorService.schedule(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            HttpConnection _connection;
                            Map map = HttpClient.this.connectionMap;
                            synchronized (map) {
                                _connection = (HttpConnection)HttpClient.this.connectionPool.borrowObject();
                                HttpClient.this.connectionMap.put(request, _connection);
                            }
                            try {
                                _connection.send(request);
                                request.onResponse(request.getResponse());
                            }
                            catch (MalformedURLException exception) {
                                if (LOGGER.isLoggable(Level.WARNING)) {
                                    LOGGER.log(Level.WARNING, "", exception);
                                }
                            }
                            catch (SocketException exception2) {
                                Map exception2 = HttpClient.this.connectionMap;
                                synchronized (exception2) {
                                    HttpClient.this.connectionMap.remove(request);
                                    HttpClient.this.connectionPool.returnObject(_connection);
                                }
                            }
                            catch (IOException exception) {
                                if (LOGGER.isLoggable(Level.WARNING)) {
                                    LOGGER.log(Level.WARNING, "", exception);
                                }
                            }
                            finally {
                                Map exception = HttpClient.this.connectionMap;
                                synchronized (exception) {
                                    HttpClient.this.connectionMap.remove(request);
                                    HttpClient.this.connectionPool.returnObject(_connection);
                                }
                            }
                        }
                    }, 0L, TimeUnit.MILLISECONDS));
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNow(HttpRequest request) throws IOException, MalformedURLException {
        if (!this.shutdown) {
            this.lock.lock();
            try {
                if (!this.shutdown) {
                    HttpConnection _connection = this.connectionPool.borrowObject();
                    _connection.send(request);
                    this.connectionPool.returnObject(_connection);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (!this.shutdown) {
            this.lock.lock();
            try {
                if (!this.shutdown) {
                    for (HttpRequest request : this.pendingRequestMap.keySet()) {
                        this.cancel(request);
                    }
                    this.cookieHandler.clear();
                    this.scheduledExecutorService.shutdownNow();
                    this.connectionPool.shutdown();
                    this.shutdown = true;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

