/*
 * Decompiled with CFR 0.152.
 */
package org.icepush.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CookieHandler;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepush.client.HttpRequest;
import org.icepush.client.HttpResponse;

public class HttpConnection {
    private static final Logger LOGGER = Logger.getLogger(HttpConnection.class.getName());
    private final CookieHandler cookieHandler;
    private HttpURLConnection connection;

    protected HttpConnection(CookieHandler cookieHandler) {
        this.cookieHandler = cookieHandler;
    }

    public void close() {
        if (this.connection != null) {
            this.connection.disconnect();
            this.connection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void send(HttpRequest request) throws IOException, MalformedURLException {
        this.connection = (HttpURLConnection)request.getRequestURI().toURL().openConnection();
        try {
            Map<String, List<String>> _cookieHeaderMap = this.cookieHandler.get(request.getRequestURI(), this.connection.getRequestProperties());
            for (String _cookie : _cookieHeaderMap.get("Cookie")) {
                this.connection.addRequestProperty("Cookie", _cookie);
            }
            if (request.getMethod() == HttpRequest.Method.POST) {
                this.connection.setDoOutput(true);
                OutputStream _out = this.connection.getOutputStream();
                try {
                    _out.write(request.getEntityBody());
                    _out.flush();
                }
                finally {
                    _out.close();
                }
            }
            InputStream _in = this.connection.getInputStream();
            this.cookieHandler.put(request.getRequestURI(), this.connection.getHeaderFields());
            try {
                int _byte;
                ByteArrayOutputStream _out = new ByteArrayOutputStream();
                while ((_byte = _in.read()) != -1) {
                    _out.write(_byte);
                }
                request.onResponse(new HttpResponse(this.connection.getResponseCode(), this.connection.getResponseMessage(), this.connection.getHeaderFields(), _out.toByteArray()));
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "\r\n\r\nHTTP Request:\r\n\r\n" + request + "\r\n\r\n" + "HTTP Response:\r\n\r\n" + request.getResponse() + "\r\n");
                }
            }
            catch (RuntimeException exception) {
                LOGGER.log(Level.SEVERE, "", exception);
                throw exception;
            }
            finally {
                _in.close();
            }
        }
        finally {
            if (this.connection != null) {
                this.connection.disconnect();
                this.connection = null;
            }
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Sending " + request.getRequestURI() + ":: Done!");
            }
        }
    }
}

