/*
 * Decompiled with CFR 0.152.
 */
package org.icepush.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpMessage {
    private static final Logger LOGGER = Logger.getLogger(HttpMessage.class.getName());
    private final Map<String, List<String>> headerMap = new HashMap<String, List<String>>();
    private final byte[] entityBody;

    protected HttpMessage() {
        this(new byte[0]);
    }

    protected HttpMessage(byte[] entityBody) {
        this.entityBody = entityBody;
    }

    protected HttpMessage(Map<String, List<String>> headerMap) {
        this(headerMap, new byte[0]);
    }

    protected HttpMessage(Map<String, List<String>> headerMap, byte[] entityBody) {
        this.headerMap.putAll(headerMap);
        this.entityBody = entityBody;
    }

    public void addHeader(String fieldName, String fieldValue) {
        if (this.headerMap.containsKey(fieldName)) {
            this.headerMap.get(fieldName).add(fieldValue);
        } else {
            ArrayList<String> _fieldValueList = new ArrayList<String>();
            _fieldValueList.add(fieldValue);
            this.headerMap.put(fieldName, _fieldValueList);
        }
    }

    public byte[] getEntityBody() {
        return this.entityBody;
    }

    public String getEntityBodyAsString() {
        return new String(this.entityBody);
    }

    public List<String> getHeader(String fieldName) {
        if (this.headerMap.containsKey(fieldName)) {
            return Collections.unmodifiableList(this.headerMap.get(fieldName));
        }
        return null;
    }

    public Map<String, List<String>> getHeaders() {
        return Collections.unmodifiableMap(this.headerMap);
    }

    public void setHeader(String fieldName, String fieldValue) {
        ArrayList<String> _fieldValueList = new ArrayList<String>();
        _fieldValueList.add(fieldValue);
        this.headerMap.put(fieldName, _fieldValueList);
    }
}

