/*
 * Decompiled with CFR 0.152.
 */
package org.icepush.client;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.icepush.client.HttpMessage;
import org.icepush.client.HttpResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpRequest
extends HttpMessage {
    private static final Logger LOGGER = Logger.getLogger(HttpRequest.class.getName());
    protected static final String CR_LF = "\r\n";
    private final Method method;
    private final URI requestURI;
    private HttpResponse response;

    protected HttpRequest(Method method, URI requestURI) {
        this(method, requestURI, new byte[0]);
    }

    protected HttpRequest(Method method, URI requestURI, Map<String, List<String>> headerMap) {
        this(method, requestURI, headerMap, new byte[0]);
    }

    protected HttpRequest(Method method, URI requestURI, Map<String, List<String>> headerMap, byte[] entityBody) {
        super(headerMap, entityBody);
        this.method = method;
        this.requestURI = requestURI;
    }

    protected HttpRequest(Method method, URI requestURI, byte[] entityBody) {
        super(entityBody);
        this.method = method;
        this.requestURI = requestURI;
    }

    public Method getMethod() {
        return this.method;
    }

    public URI getRequestURI() {
        return this.requestURI;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public void onResponse(HttpResponse response) {
        this.response = response;
    }

    public String toString() {
        Map<String, List<String>> _headerMap = this.getHeaders();
        StringBuilder _request = new StringBuilder();
        _request.append("[").append((Object)this.method).append(' ').append(this.requestURI).append("]\r\n");
        for (String _fieldName : _headerMap.keySet()) {
            if (_fieldName == null) continue;
            for (String _fieldValue : _headerMap.get(_fieldName)) {
                _request.append(_fieldName).append(": ").append(_fieldValue).append(CR_LF);
            }
        }
        _request.append(CR_LF).append(this.getEntityBodyAsString());
        return _request.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Method {
        GET,
        POST;

    }
}

