/*
 * Decompiled with CFR 0.152.
 */
package org.icepush.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.icepush.client.HttpMessage;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpResponse
extends HttpMessage {
    private static final Logger LOGGER = Logger.getLogger(HttpResponse.class.getName());
    private final int statusCode;
    private final String reasonPhrase;

    public HttpResponse(int statusCode, String reasonPhrase, Map<String, List<String>> headerMap, byte[] entityBody) {
        super(Collections.unmodifiableMap(headerMap), entityBody);
        this.statusCode = statusCode;
        this.reasonPhrase = reasonPhrase;
    }

    @Override
    public void addHeader(String fieldName, String fieldValue) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Document getEntityBodyAsDocument() {
        block9: {
            byte[] _entityBody = this.getEntityBody();
            if (_entityBody.length > 0) {
                try {
                    return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(_entityBody));
                }
                catch (FactoryConfigurationError error) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "An error occurred while trying to get a new DocumentBuilderFactory instance: 'The implementation is not available or cannot be instantiated.'", error);
                    }
                }
                catch (ParserConfigurationException exception) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "An error occurred while trying to get a new DocumentBuilder instance: 'A DocumentBuilder cannot be created which satisfies the configuration requested.'", exception);
                    }
                }
                catch (IOException exception) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "An I/O error occurred while trying to parse the Entity-Body: '" + new String(_entityBody) + "'", exception);
                    }
                }
                catch (SAXException exception) {
                    if (!LOGGER.isLoggable(Level.FINEST)) break block9;
                    LOGGER.log(Level.FINEST, "A parse error occurred while trying to parse the Entity-Body: '" + new String(_entityBody) + "'", exception);
                }
            }
        }
        return null;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public void setHeader(String fieldName, String fieldValue) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        Map<String, List<String>> _headerMap = this.getHeaders();
        StringBuilder _response = new StringBuilder();
        _response.append(_headerMap.get(null)).append("\r\n");
        for (String _fieldName : _headerMap.keySet()) {
            if (_fieldName == null) continue;
            for (String _fieldValue : _headerMap.get(_fieldName)) {
                _response.append(_fieldName).append(": ").append(_fieldValue).append("\r\n");
            }
        }
        _response.append("\r\n").append(this.getEntityBodyAsString());
        return _response.toString();
    }

    public static final class StatusCode {
        public static final int OK = 200;

        private StatusCode() {
        }
    }
}

