/*
 * Decompiled with CFR 0.152.
 */
package org.icepush.client;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectPool<O> {
    private static final Logger LOGGER = Logger.getLogger(ObjectPool.class.getName());
    private final ReentrantLock lock = new ReentrantLock(true);
    private final Condition available = this.lock.newCondition();
    private final List<O> inList = new ArrayList<O>();
    private final List<O> outList = new ArrayList<O>();
    private final int maxSize;

    protected ObjectPool(int maxSize) {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "ObjectPool :: maxSize: '" + maxSize + "'");
        }
        this.maxSize = maxSize;
    }

    public O borrowObject() {
        this.lock.lock();
        try {
            while (true) {
                if (!this.inList.isEmpty()) {
                    O _object = this.inList.remove(0);
                    this.outList.add(_object);
                    O o = _object;
                    return o;
                }
                if (this.outList.size() != this.maxSize) {
                    O _object = this.newObject();
                    this.outList.add(_object);
                    O o = _object;
                    return o;
                }
                this.available.awaitUninterruptibly();
            }
        }
        finally {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "ObjectPool :: in: '" + this.inList.size() + "', out: '" + this.outList.size() + "'");
            }
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateObject(O object) {
        this.lock.lock();
        try {
            if (this.outList.contains(object)) {
                this.outList.remove(object);
                if (this.outList.size() == this.maxSize - 1) {
                    this.available.signal();
                }
            }
        }
        finally {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "ObjectPool :: in: '" + this.inList.size() + "', out: '" + this.outList.size() + "'");
            }
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(O object) {
        this.lock.lock();
        try {
            if (this.outList.contains(object)) {
                this.outList.remove(object);
                this.inList.add(object);
                if (this.inList.size() == 1) {
                    this.available.signal();
                }
            }
        }
        finally {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "ObjectPool :: in: '" + this.inList.size() + "', out: '" + this.outList.size() + "'");
            }
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.lock.lock();
        try {
            this.outList.clear();
            this.inList.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected abstract O newObject();
}

