/*
 * Decompiled with CFR 0.152.
 */
package org.icepush.http.standard;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import org.icepush.http.Request;
import org.icepush.http.Response;
import org.icepush.http.ResponseHandler;
import org.icepush.http.Server;
import org.icepush.http.standard.RequestProxy;

public class CacheControlledServer
implements Server {
    private static final Date ExpirationDate = new Date(System.currentTimeMillis() + 2629743830L);
    private static final Collection cache = new HashSet();
    private static final Date StartupTime = new Date();
    private Server server;

    public CacheControlledServer(Server server) {
        this.server = server;
    }

    public void service(Request request) throws Exception {
        if (cache.contains(request.getHeader("If-None-Match"))) {
            request.respondWith(new NotModifiedHandler(ExpirationDate));
        } else {
            try {
                Date modifiedSince = request.getHeaderAsDate("If-Modified-Since");
                if (StartupTime.getTime() - modifiedSince.getTime() > 1000L) {
                    this.server.service(new EnhancedRequest(request));
                } else {
                    request.respondWith(new NotModifiedHandler(ExpirationDate));
                }
            }
            catch (Exception e) {
                this.server.service(new EnhancedRequest(request));
            }
        }
    }

    public void shutdown() {
        cache.clear();
    }

    private static class NotModifiedHandler
    implements ResponseHandler {
        private Date expirationDate;

        public NotModifiedHandler(Date expirationDate) {
            this.expirationDate = expirationDate;
        }

        public void respond(Response response) throws Exception {
            response.setStatus(304);
            response.setHeader("Date", new Date());
            response.setHeader("Expires", this.expirationDate);
            response.setHeader("Content-Length", 0);
        }
    }

    private class EnhancedRequest
    extends RequestProxy {
        public EnhancedRequest(Request request) {
            super(request);
        }

        public void respondWith(final ResponseHandler handler) throws Exception {
            this.getRequest().respondWith(new ResponseHandler(){

                public void respond(Response response) throws Exception {
                    String eTag = Integer.toHexString(EnhancedRequest.this.getRequest().getURI().hashCode());
                    cache.add(eTag);
                    response.setHeader("ETag", eTag);
                    response.setHeader("Cache-Control", new String[]{"private", "max-age=2629743"});
                    response.setHeader("Last-Modified", StartupTime);
                    handler.respond(response);
                }
            });
        }
    }
}

