/*
 * Decompiled with CFR 0.152.
 */
package org.icepush.http.standard;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.icepush.http.Request;
import org.icepush.http.Response;
import org.icepush.http.ResponseHandler;
import org.icepush.http.Server;
import org.icepush.http.standard.RequestProxy;
import org.icepush.http.standard.ResponseProxy;

public class CompressingServer
implements Server {
    private Server server;

    public CompressingServer(Server server) {
        this.server = server;
    }

    public void service(Request request) throws Exception {
        String acceptEncodingHeader = request.getHeader("Accept-Encoding");
        if (acceptEncodingHeader != null && (acceptEncodingHeader.indexOf("gzip") >= 0 || acceptEncodingHeader.indexOf("compress") >= 0)) {
            this.server.service(new CompressingRequest(request));
        } else {
            this.server.service(request);
        }
    }

    public void shutdown() {
        this.server.shutdown();
    }

    private static void copy(InputStream input, OutputStream output) throws IOException {
        int len;
        byte[] buf = new byte[4096];
        while ((len = input.read(buf)) > -1) {
            output.write(buf, 0, len);
        }
    }

    private class CompressingResponse
    extends ResponseProxy {
        private GZIPOutputStream output;

        public CompressingResponse(Response response) {
            super(response);
            response.setHeader("Content-Encoding", "gzip");
        }

        public OutputStream writeBody() throws IOException {
            this.output = new GZIPOutputStream(this.getResponse().writeBody());
            return this.output;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeBodyFrom(InputStream in) throws IOException {
            try {
                CompressingServer.copy(in, this.writeBody());
            }
            finally {
                in.close();
            }
        }

        public void finishCompression() throws IOException {
            if (this.output != null) {
                this.output.finish();
            }
        }
    }

    private class CompressingRequest
    extends RequestProxy {
        public CompressingRequest(Request request) {
            super(request);
        }

        public void respondWith(final ResponseHandler handler) throws Exception {
            this.getRequest().respondWith(new ResponseHandler(){

                public void respond(Response response) throws Exception {
                    CompressingResponse compressingResponse = new CompressingResponse(response);
                    handler.respond(compressingResponse);
                    compressingResponse.finishCompression();
                }
            });
        }
    }
}

