/*
 * Decompiled with CFR 0.152.
 */
package org.icepush.http.standard;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepush.http.Request;
import org.icepush.http.Response;

public class Cookie {
    private static final Logger log = Logger.getLogger(Cookie.class.getName());
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss zzz");
    private String name;
    private String value;
    private Date expiration;
    private String path;
    private String domain;

    public Cookie(String name, String value) {
        this(name, value, null, "/", null);
    }

    public Cookie(String name, String value, Date expiration, String path, String domain) {
        this.name = name;
        this.value = value;
        this.expiration = expiration;
        this.path = path;
        this.domain = domain;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String asString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.name);
        buffer.append("=");
        buffer.append(this.value);
        if (this.expiration != null) {
            buffer.append("; expires=");
            buffer.append(DATE_FORMAT.format(this.expiration));
        }
        if (this.path != null) {
            buffer.append("; path=");
            buffer.append(this.path);
        }
        if (this.domain != null) {
            buffer.append("; domain=");
            buffer.append(this.domain);
        }
        return buffer.toString();
    }

    public void writeCookie(Response response) {
        response.setHeader("Set-Cookie", this.asString());
    }

    public static Cookie readCookie(Request request, String cookieName) {
        javax.servlet.http.Cookie[] treats;
        int i;
        String cookies = request.getHeader("Cookie");
        if (null != cookies) {
            String[] cookieString = cookies.split("; ");
            for (i = 0; i < cookieString.length; ++i) {
                String[] nameValue = cookieString[i].split("=");
                String name = nameValue[0];
                if (!cookieName.equals(name)) continue;
                return new Cookie(name, nameValue.length > 1 ? nameValue[1] : "");
            }
        }
        if (null != (treats = request.getCookies())) {
            for (i = 0; i < treats.length; ++i) {
                javax.servlet.http.Cookie treat = treats[i];
                if (!treat.getName().equalsIgnoreCase(cookieName)) continue;
                return new Cookie(treat.getName(), treat.getValue());
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "could not get cookie " + cookieName);
        }
        return null;
    }

    static {
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

