/*
 * Decompiled with CFR 0.152.
 */
package org.icepush.jsp.tags;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.icepush.PushContext;
import org.icepush.notify.GroupNotifier;
import org.icepush.notify.Notifier;

public class BaseTag
extends TagSupport {
    protected String group;
    protected String notifier;
    protected String pushid;

    public int doStartTag() throws JspException {
        PushContext pc = PushContext.getInstance(this.pageContext.getServletContext());
        if (pc == null) {
            throw new JspException("PushContext not available in BaseTag.doStartTag()");
        }
        this.pushid = pc.createPushId((HttpServletRequest)this.pageContext.getRequest(), (HttpServletResponse)this.pageContext.getResponse());
        Notifier notifierBean = null;
        if (this.notifier != null) {
            notifierBean = (Notifier)this.pageContext.findAttribute(this.notifier);
            if (notifierBean != null) {
                notifierBean.setPushContext(pc);
            } else {
                throw new JspException("Could not find notifier bean " + this.notifier);
            }
        }
        if (this.group == null) {
            this.group = this.pushid;
        }
        pc.addGroupMember(this.group, this.pushid);
        if (notifierBean != null) {
            try {
                GroupNotifier gnotifier = (GroupNotifier)notifierBean;
                gnotifier.setGroup(this.group);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return 0;
    }

    public void release() {
        this.group = null;
        this.notifier = null;
        this.pushid = null;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String grp) {
        this.group = grp;
    }

    public String getNotifier() {
        return this.notifier;
    }

    public void setNotifier(String notifier) {
        this.notifier = notifier;
    }
}

