/*
 * Decompiled with CFR 0.152.
 */
package org.icepush.jsp.timer;

import java.util.Hashtable;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.icepush.PushContext;

public class GroupIntervalTimer
implements ServletContextListener {
    private Timer timer;
    private Map<String, TimerTask> timerTasks;
    private PushContext pushContext;

    public void contextInitialized(ServletContextEvent e) {
        this.timer = new Timer(true);
        this.timerTasks = new Hashtable<String, TimerTask>();
        e.getServletContext().setAttribute("ICEpushJSPtimer", (Object)this);
    }

    public void contextDestroyed(ServletContextEvent e) {
        this.timer.cancel();
    }

    public void addGroup(String group, long interval) throws IllegalStateException {
        GroupTimerTask timerTask = (GroupTimerTask)this.timerTasks.get(group);
        if (timerTask == null) {
            if (interval > 0L) {
                this.startTimerTask(group, interval);
            }
        } else if (interval > 0L) {
            if (interval != timerTask.getInterval()) {
                timerTask.cancel();
                this.startTimerTask(group, interval);
            }
        } else {
            this.timerTasks.remove(group);
        }
    }

    private void startTimerTask(String group, long interval) throws IllegalStateException {
        GroupTimerTask timerTask = new GroupTimerTask(group, interval);
        this.timerTasks.put(group, timerTask);
        try {
            this.timer.scheduleAtFixedRate((TimerTask)timerTask, interval, interval);
        }
        catch (Exception e) {
            throw new IllegalStateException("GroupIntervalTimer could not start timerTask for group: " + group);
        }
    }

    public void setPushContext(PushContext pc) {
        this.pushContext = pc;
    }

    public PushContext getPushContext() {
        return this.pushContext;
    }

    private class GroupTimerTask
    extends TimerTask {
        private long interval;
        private String group;

        public GroupTimerTask(String group, long interval) {
            this.interval = interval;
            this.group = group;
        }

        public long getInterval() {
            return this.interval;
        }

        public void setInterval(long interval) {
            this.interval = interval;
        }

        public void run() {
            GroupIntervalTimer.this.pushContext.push(this.group);
        }
    }
}

