/*
 * Decompiled with CFR 0.152.
 */
package org.icepush.servlet;

import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.icepush.Configuration;
import org.icepush.http.PushResponseHandler;
import org.icepush.http.PushServer;
import org.icepush.servlet.EnvironmentAdaptingException;
import org.icepush.servlet.PseudoServlet;
import org.icepush.servlet.ServletPushRequestResponse;
import org.icepush.util.Slot;

public class AsyncAdaptingServlet
implements PseudoServlet {
    private static final Logger LOGGER = Logger.getLogger(AsyncAdaptingServlet.class.getName());
    private final Configuration configuration;
    private final Slot heartbeatInterval;
    private final PushServer pushServer;

    public AsyncAdaptingServlet(PushServer pushServer, Slot heartbeatInterval, Configuration configuration) {
        this.pushServer = pushServer;
        this.heartbeatInterval = heartbeatInterval;
        this.configuration = configuration;
        LOGGER.info("Using Servlet 3.0 AsyncContext");
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!request.isAsyncSupported()) {
            throw new EnvironmentAdaptingException();
        }
        AsyncRequestResponse requestResponse = new AsyncRequestResponse(request, response, this.configuration);
        this.pushServer.service(requestResponse);
    }

    public void shutdown() {
        this.pushServer.shutdown();
    }

    private class AsyncRequestResponse
    extends ServletPushRequestResponse {
        private AsyncContext asyncContext;

        public AsyncRequestResponse(HttpServletRequest request, HttpServletResponse response, Configuration configuration) throws Exception {
            super(request, response, configuration);
            this.asyncContext = request.isAsyncStarted() ? request.getAsyncContext() : request.startAsync();
            long _timeout = AsyncAdaptingServlet.this.heartbeatInterval.getLongValue() * 3L;
            this.asyncContext.setTimeout(_timeout);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void respondWith(PushResponseHandler handler) throws Exception {
            try {
                super.respondWith(handler);
            }
            finally {
                this.asyncContext.complete();
            }
        }
    }
}

