/*
 * Decompiled with CFR 0.152.
 */
package org.icepush.servlet;

import java.util.Date;
import java.util.Map;
import java.util.Timer;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.icepush.BlockingConnectionServer;
import org.icepush.Configuration;
import org.icepush.ConfigurationServer;
import org.icepush.PushConfiguration;
import org.icepush.PushContext;
import org.icepush.PushStormDetectionServer;
import org.icepush.SequenceTaggingServer;
import org.icepush.http.PushServer;
import org.icepush.servlet.AbstractPseudoServlet;
import org.icepush.servlet.EnvironmentAdaptingServlet;
import org.icepush.servlet.PathDispatcher;
import org.icepush.servlet.PseudoServlet;
import org.icepush.util.Slot;

public class BrowserBoundServlet
extends PathDispatcher
implements PseudoServlet {
    private static final Logger log = Logger.getLogger(BrowserBoundServlet.class.getName());
    private static final Pattern NAME_VALUE = Pattern.compile("\\=");
    protected final String browserID;
    protected final Configuration configuration;
    protected final Slot heartbeatInterval;
    protected final Timer monitoringScheduler;
    protected final PushContext pushContext;
    protected final ServletContext servletContext;
    protected final boolean terminateBlockingConnectionOnShutdown;
    protected boolean setUp = false;

    public BrowserBoundServlet(String browserID, PushContext pushContext, ServletContext servletContext, Timer monitoringScheduler, Configuration configuration, boolean terminateBlockingConnectionOnShutdown) {
        this.browserID = browserID;
        this.pushContext = pushContext;
        this.servletContext = servletContext;
        this.monitoringScheduler = monitoringScheduler;
        this.configuration = configuration;
        this.terminateBlockingConnectionOnShutdown = terminateBlockingConnectionOnShutdown;
        this.heartbeatInterval = new Slot(configuration.getAttributeAsLong("heartbeatTimeout", 15000L));
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws Exception, IllegalStateException {
        this.checkSetUp();
        super.service(request, response);
    }

    public void setUp() {
        this.dispatchOn(".*listen\\.icepush", this.newListen());
        this.dispatchOn(".*create-push-id\\.icepush", this.newCreatePushID());
        this.dispatchOn(".*notify\\.icepush", this.newNotifyPushID());
        this.dispatchOn(".*add-group-member\\.icepush", this.newAddGroupMember());
        this.dispatchOn(".*remove-group-member\\.icepush", this.newRemoveGroupMember());
        this.setUp = true;
    }

    public void shutdown() throws IllegalStateException {
        this.checkSetUp();
        super.shutdown();
    }

    protected void checkSetUp() throws IllegalStateException {
        if (!this.setUp) {
            throw new IllegalStateException("Browser Bound Servlet is not set-up.");
        }
    }

    protected PushServer createBlockingConnectionServer() {
        Slot sequenceNo = new Slot(0L);
        return new ConfigurationServer(this.heartbeatInterval, this.servletContext, this.configuration, new PushStormDetectionServer(new SequenceTaggingServer(sequenceNo, this.newBlockingConnectionServer()), this.configuration));
    }

    protected PseudoServlet newAddGroupMember() {
        return new AddGroupMember();
    }

    protected BlockingConnectionServer newBlockingConnectionServer() {
        BlockingConnectionServer _blockBlockingConnectionServer = new BlockingConnectionServer(this.browserID, this.monitoringScheduler, this.heartbeatInterval, this.terminateBlockingConnectionOnShutdown, this.configuration);
        _blockBlockingConnectionServer.setUp();
        return _blockBlockingConnectionServer;
    }

    protected PseudoServlet newCreatePushID() {
        return new CreatePushID();
    }

    protected PseudoServlet newListen() {
        return new EnvironmentAdaptingServlet(this.createBlockingConnectionServer(), this.heartbeatInterval, this.configuration);
    }

    protected PseudoServlet newNotifyPushID() {
        return new NotifyPushID();
    }

    protected PseudoServlet newRemoveGroupMember() {
        return new RemoveGroupMember();
    }

    protected class RemoveGroupMember
    extends AbstractPseudoServlet
    implements PseudoServlet {
        protected RemoveGroupMember() {
        }

        public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
            String group = request.getParameter("group");
            String pushID = request.getParameter("id");
            this.removeGroupMember(group, pushID);
            response.setContentType("text/plain");
            response.setContentLength(0);
        }

        protected void removeGroupMember(String groupName, String pushID) {
            BrowserBoundServlet.this.pushContext.removeGroupMember(groupName, pushID);
        }
    }

    protected class NotifyPushID
    extends AbstractPseudoServlet
    implements PseudoServlet {
        protected NotifyPushID() {
        }

        public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
            String duration;
            String at;
            String duration2;
            String delay;
            PushConfiguration pushConfiguration;
            String groupName = request.getParameter("group");
            String[] options = request.getParameterValues("option");
            if (options != null && options.length > 0) {
                pushConfiguration = new PushConfiguration();
                Map<String, Object> attributes = pushConfiguration.getAttributes();
                for (int i = 0; i < options.length; ++i) {
                    String option = options[i];
                    String[] nameValue = NAME_VALUE.split(option);
                    attributes.put(nameValue[0], nameValue[1]);
                }
            } else {
                pushConfiguration = null;
            }
            if ((delay = request.getParameter("delay")) != null && (duration2 = request.getParameter("duration")) != null) {
                if (pushConfiguration == null) {
                    pushConfiguration = new PushConfiguration();
                }
                pushConfiguration.delayed(Long.parseLong(delay), Long.parseLong(duration2));
            }
            if ((at = request.getParameter("at")) != null && (duration = request.getParameter("duration")) != null) {
                if (pushConfiguration == null) {
                    pushConfiguration = new PushConfiguration();
                }
                pushConfiguration.scheduled(new Date(Long.parseLong(at)), Long.parseLong(duration));
            }
            if (pushConfiguration == null) {
                this.push(groupName);
            } else {
                this.push(groupName, pushConfiguration);
            }
            response.setContentType("text/plain");
            response.setContentLength(0);
        }

        protected void push(String groupName) {
            BrowserBoundServlet.this.pushContext.push(groupName);
        }

        protected void push(String groupName, PushConfiguration pushConfiguration) {
            BrowserBoundServlet.this.pushContext.push(groupName, pushConfiguration);
        }
    }

    protected class CreatePushID
    extends AbstractPseudoServlet
    implements PseudoServlet {
        protected CreatePushID() {
        }

        public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
            response.setContentType("text/plain");
            response.getOutputStream().print(this.createPushID(request, response));
        }

        protected String createPushID(HttpServletRequest request, HttpServletResponse response) {
            return BrowserBoundServlet.this.pushContext.createPushId(request, response);
        }
    }

    protected class AddGroupMember
    extends AbstractPseudoServlet
    implements PseudoServlet {
        protected AddGroupMember() {
        }

        public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
            String groupName = request.getParameter("group");
            String pushID = request.getParameter("id");
            this.addGroupMember(groupName, pushID);
            response.setContentType("text/plain");
            response.setContentLength(0);
        }

        protected void addGroupMember(String groupName, String pushID) {
            BrowserBoundServlet.this.pushContext.addGroupMember(groupName, pushID);
        }
    }
}

