/*
 * Decompiled with CFR 0.152.
 */
package org.icepush.servlet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.icepush.Browser;
import org.icepush.Configuration;
import org.icepush.servlet.PseudoServlet;

public abstract class BrowserDispatcher
implements PseudoServlet {
    private static final Logger log = Logger.getLogger(BrowserDispatcher.class.getName());
    private final long browserTimeout;
    protected final Map<String, BrowserEntry> browserBoundServlets = new HashMap<String, BrowserEntry>();

    public BrowserDispatcher(Configuration configuration) {
        this.browserTimeout = configuration.getAttributeAsLong("browserTimeout", 600000L);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.discardUnusedServlets();
        String browserID = Browser.getBrowserID(request);
        this.checkSession(browserID);
        this.lookupServer(browserID).service(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Map<String, BrowserEntry> map = this.browserBoundServlets;
        synchronized (map) {
            ArrayList<BrowserEntry> browserEntryList = new ArrayList<BrowserEntry>(this.browserBoundServlets.values());
            for (BrowserEntry browserEntry : browserEntryList) {
                browserEntry.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSession(String browserID) throws Exception {
        Map<String, BrowserEntry> map = this.browserBoundServlets;
        synchronized (map) {
            if (!this.browserBoundServlets.containsKey(browserID)) {
                this.browserBoundServlets.put(browserID, new BrowserEntry(browserID, this.newServer(browserID)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void discardUnusedServlets() {
        Map<String, BrowserEntry> map = this.browserBoundServlets;
        synchronized (map) {
            ArrayList<BrowserEntry> browserEntryList = new ArrayList<BrowserEntry>(this.browserBoundServlets.values());
            for (BrowserEntry browserEntry : browserEntryList) {
                browserEntry.discardIfExpired();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PseudoServlet lookupServer(String browserID) {
        Map<String, BrowserEntry> map = this.browserBoundServlets;
        synchronized (map) {
            return this.browserBoundServlets.get(browserID);
        }
    }

    protected abstract PseudoServlet newServer(String var1) throws Exception;

    protected class BrowserEntry
    implements PseudoServlet {
        private String id;
        private PseudoServlet servlet;
        private long lastAccess = System.currentTimeMillis();

        public BrowserEntry(String id, PseudoServlet servlet) {
            this.id = id;
            this.servlet = servlet;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("New browser detected, assigning ID '" + id + "'.");
            }
        }

        public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
            this.lastAccess = System.currentTimeMillis();
            this.servlet.service(request, response);
        }

        public void shutdown() {
            this.servlet.shutdown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void discardIfExpired() {
            if (this.lastAccess + BrowserDispatcher.this.browserTimeout < System.currentTimeMillis()) {
                try {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Discard browser with ID '" + this.id + "' since is no longer used.");
                    }
                    this.servlet.shutdown();
                }
                catch (Throwable t) {
                    log.fine("Failed to discard browser bound server for ID=" + this.id);
                }
                finally {
                    Map<String, BrowserEntry> map = BrowserDispatcher.this.browserBoundServlets;
                    synchronized (map) {
                        BrowserDispatcher.this.browserBoundServlets.remove(this.id);
                    }
                    log.fine("Discarded browser bound server for ID=" + this.id);
                }
            }
        }
    }
}

