/*
 * Decompiled with CFR 0.152.
 */
package org.icepush.servlet;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CustomHeaderFilter
implements Filter {
    private FilterConfig filterConfig = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public void destroy() {
        this.filterConfig = null;
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse httpResp = (HttpServletResponse)resp;
        HttpServletRequest httpRequest = (HttpServletRequest)req;
        Enumeration headerNames = this.filterConfig.getInitParameterNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String headerValue = this.filterConfig.getInitParameter(headerName);
            if ("Access-Control-Allow-Origin".equalsIgnoreCase(headerName) && "*".equals(headerValue)) {
                String origin = httpRequest.getHeader("Origin");
                httpResp.addHeader("Access-Control-Allow-Origin", origin);
                continue;
            }
            httpResp.addHeader(headerName, headerValue);
        }
        String method = httpRequest.getMethod();
        if ("OPTIONS".equalsIgnoreCase(method)) {
            return;
        }
        chain.doFilter(req, resp);
    }
}

