/*
 * Decompiled with CFR 0.152.
 */
package org.icepush.servlet;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.icepush.Configuration;
import org.icepush.http.PushServer;
import org.icepush.servlet.AsyncAdaptingServlet;
import org.icepush.servlet.EnvironmentAdaptingException;
import org.icepush.servlet.PseudoServlet;
import org.icepush.servlet.ThreadBlockingAdaptingServlet;
import org.icepush.util.Slot;

public class EnvironmentAdaptingServlet
implements PseudoServlet {
    private static final Logger LOGGER = Logger.getLogger(EnvironmentAdaptingServlet.class.getName());
    private final Configuration configuration;
    private final Slot heartbeatInterval;
    private final PushServer pushServer;
    private PseudoServlet servlet;

    public EnvironmentAdaptingServlet(PushServer pushServer, Slot heartbeatInterval, Configuration configuration) {
        this.pushServer = pushServer;
        this.heartbeatInterval = heartbeatInterval;
        this.configuration = configuration;
        if (configuration.getAttributeAsBoolean("useAsyncContext", this.isAsyncARPAvailable())) {
            LOGGER.log(Level.INFO, "Adapting to Servlet 3.0 AsyncContext environment");
            this.servlet = new AsyncAdaptingServlet(this.pushServer, this.heartbeatInterval, this.configuration);
        } else {
            LOGGER.log(Level.INFO, "Adapting to Thread Blocking environment");
            this.servlet = new ThreadBlockingAdaptingServlet(this.pushServer, this.heartbeatInterval, this.configuration);
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            this.servlet.service(request, response);
        }
        catch (EnvironmentAdaptingException exception) {
            LOGGER.log(Level.INFO, "Falling back to Thread Blocking environment");
            this.servlet = new ThreadBlockingAdaptingServlet(this.pushServer, this.heartbeatInterval, this.configuration);
            this.servlet.service(request, response);
        }
    }

    public void shutdown() {
        this.servlet.shutdown();
    }

    private boolean isAsyncARPAvailable() {
        try {
            this.getClass().getClassLoader().loadClass("javax.servlet.AsyncContext");
            return true;
        }
        catch (ClassNotFoundException exception) {
            return false;
        }
    }
}

