/*
 * Decompiled with CFR 0.152.
 */
package org.icepush.servlet;

import java.net.SocketException;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Timer;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.icepush.CheckBrowserIDServlet;
import org.icepush.CodeServer;
import org.icepush.Configuration;
import org.icepush.NotificationProvider;
import org.icepush.OutOfBandNotifier;
import org.icepush.ProductInfo;
import org.icepush.PushContext;
import org.icepush.PushGroupManager;
import org.icepush.PushGroupManagerFactory;
import org.icepush.PushInternalContext;
import org.icepush.PushNotification;
import org.icepush.RemoveParameterPrefix;
import org.icepush.http.standard.CacheControlledServer;
import org.icepush.http.standard.CompressingServer;
import org.icepush.servlet.BasicAdaptingServlet;
import org.icepush.servlet.BrowserBoundServlet;
import org.icepush.servlet.BrowserDispatcher;
import org.icepush.servlet.PathDispatcher;
import org.icepush.servlet.PseudoServlet;
import org.icepush.servlet.ServletContextConfiguration;
import org.icepush.util.ExtensionRegistry;

public class MainServlet
implements PseudoServlet {
    private static final Logger log = Logger.getLogger(MainServlet.class.getName());
    static HashSet<TraceListener> traceListeners = new HashSet();
    protected PathDispatcher dispatcher;
    protected Timer monitoringScheduler;
    protected PushContext pushContext;
    protected ServletContext servletContext;
    protected Configuration configuration;
    protected boolean terminateConnectionOnShutdown;

    public static synchronized MainServlet getInstance(ServletContext context) {
        MainServlet mainServlet = (MainServlet)context.getAttribute(MainServlet.class.getName());
        if (null == mainServlet) {
            mainServlet = new MainServlet(context);
            context.setAttribute(MainServlet.class.getName(), (Object)mainServlet);
        }
        return mainServlet;
    }

    public MainServlet(ServletContext context) {
        this(context, true);
    }

    public MainServlet(ServletContext servletContext, boolean terminateBlockingConnectionOnShutdown) {
        this(servletContext, terminateBlockingConnectionOnShutdown, true);
    }

    public MainServlet(ServletContext servletContext, boolean terminateBlockingConnectionOnShutdown, boolean printProductInfo) {
        this(servletContext, terminateBlockingConnectionOnShutdown, printProductInfo, null);
    }

    public MainServlet(ServletContext servletContext, boolean terminateBlockingConnectionOnShutdown, boolean printProductInfo, ScheduledThreadPoolExecutor executor) {
        if (printProductInfo) {
            log.info(new ProductInfo().toString());
        }
        servletContext.setAttribute(MainServlet.class.getName(), (Object)this);
        PushInternalContext.getInstance().setAttribute(Timer.class.getName() + "$expiry", new Timer("Expiry Timeout timer", true));
        PushInternalContext.getInstance().setAttribute(Timer.class.getName() + "$confirmation", new Timer("Confirmation Timeout timer", true));
        this.servletContext = servletContext;
        this.terminateConnectionOnShutdown = terminateBlockingConnectionOnShutdown;
        this.monitoringScheduler = new Timer("Monitoring scheduler", true);
        this.configuration = new ServletContextConfiguration("org.icepush", this.servletContext);
        this.pushContext = PushContext.getInstance(this.servletContext);
        PushInternalContext.getInstance().setAttribute(PushGroupManager.class.getName(), PushGroupManagerFactory.newPushGroupManager(this.servletContext, executor, this.configuration));
        this.dispatcher = new PathDispatcher();
        this.createOutOfBandNotifier(servletContext);
        this.addDispatches();
    }

    protected void addDispatches() {
        this.dispatchOn(".*code\\.min\\.icepush", new BasicAdaptingServlet(new CacheControlledServer(new CompressingServer(new CodeServer(new String[]{"ice.core/bridge-support.js", "ice.push/icepush.js"}))), this.configuration));
        this.dispatchOn(".*code\\.icepush", new BasicAdaptingServlet(new CacheControlledServer(new CompressingServer(new CodeServer(new String[]{"ice.core/bridge-support.uncompressed.js", "ice.push/icepush.uncompressed.js"}))), this.configuration));
        this.addBrowserBoundDispatch();
    }

    protected void addBrowserBoundDispatch() {
        this.dispatchOn(".*", this.createBrowserDispatcher());
    }

    protected PseudoServlet createBrowserBoundServlet(String browserID) {
        BrowserBoundServlet browserBoundServlet = new BrowserBoundServlet(browserID, this.pushContext, this.servletContext, this.monitoringScheduler, this.configuration, this.terminateConnectionOnShutdown);
        browserBoundServlet.setUp();
        return browserBoundServlet;
    }

    protected PseudoServlet createBrowserDispatcher() {
        return new RemoveParameterPrefix(new CheckBrowserIDServlet(new BrowserDispatcher(this.configuration){

            protected PseudoServlet newServer(String browserID) {
                return MainServlet.this.createBrowserBoundServlet(browserID);
            }
        }));
    }

    protected void createOutOfBandNotifier(ServletContext servletContext) {
        new DefaultOutOfBandNotifier(servletContext);
    }

    public void dispatchOn(String pattern, PseudoServlet servlet) {
        this.dispatcher.dispatchOn(pattern, servlet);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            this.dispatcher.service(request, response);
        }
        catch (SocketException e) {
            if ("Broken pipe".equals(e.getMessage())) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINE, "Connection broken by client.", e);
                } else if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Connection broken by client: " + e.getMessage());
                }
            }
            throw new ServletException((Throwable)e);
        }
        catch (RuntimeException e) {
            if (e.getMessage() == null) {
                throw new RuntimeException("wrapped Exception: " + e, e);
            }
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void shutdown() {
        this.dispatcher.shutdown();
        ((PushGroupManager)PushInternalContext.getInstance().getAttribute(PushGroupManager.class.getName())).shutdown();
        this.monitoringScheduler.cancel();
        ((Timer)PushInternalContext.getInstance().getAttribute(Timer.class.getName() + "$confirmation")).cancel();
        PushInternalContext.getInstance().removeAttribute(Timer.class.getName() + "$confirmation");
        ((Timer)PushInternalContext.getInstance().getAttribute(Timer.class.getName() + "$expiry")).cancel();
        PushInternalContext.getInstance().removeAttribute(Timer.class.getName() + "$expiry");
    }

    public static void trace(String message) {
        for (TraceListener listener : traceListeners) {
            listener.handleTrace(message);
        }
    }

    public static void addTraceListener(TraceListener listener) {
        traceListeners.add(listener);
    }

    private static class DefaultOutOfBandNotifier
    implements OutOfBandNotifier {
        private static final Logger LOGGER = Logger.getLogger(OutOfBandNotifier.class.getName());
        private final HashMap providers = new HashMap();
        private final PushGroupManager pushGroupManager = (PushGroupManager)PushInternalContext.getInstance().getAttribute(PushGroupManager.class.getName());

        private DefaultOutOfBandNotifier(ServletContext context) {
            context.setAttribute(OutOfBandNotifier.class.getName(), (Object)this);
            Object[] extensions = ExtensionRegistry.getExtensions(context, NotificationProvider.class.getName());
            if (extensions == null) {
                LOGGER.fine("Could not find any out of band notification providers.");
            } else {
                for (int i = 0; i < extensions.length; ++i) {
                    NotificationProvider provider = (NotificationProvider)extensions[i];
                    provider.registerWith(this);
                }
            }
        }

        public void broadcast(PushNotification pushNotification, String[] browserIDs, String groupName) {
            for (String browserID : browserIDs) {
                String notifyBackURI = this.pushGroupManager.getBrowser(browserID).getNotifyBackURI().getURI();
                URI uri = URI.create(notifyBackURI);
                String protocol = uri.getScheme();
                NotificationProvider provider = (NotificationProvider)this.providers.get(protocol);
                if (provider == null) {
                    LOGGER.warning("No notification providers for '" + uri + "' URI registered");
                    continue;
                }
                try {
                    provider.send(browserID, groupName, pushNotification);
                }
                catch (Throwable t) {
                    LOGGER.log(Level.WARNING, "Exception sending message to " + browserID + ", " + t);
                }
            }
        }

        public void registerProvider(String protocol, NotificationProvider provider) {
            this.providers.put(protocol, provider);
        }

        public void trace(String message) {
            MainServlet.trace(message);
        }
    }

    public static class ExtensionRegistration
    implements ServletContextListener {
        public void contextInitialized(ServletContextEvent servletContextEvent) {
            ExtensionRegistry.addExtension(servletContextEvent.getServletContext(), 1, "org.icepush.MainServlet", MainServlet.class);
        }

        public void contextDestroyed(ServletContextEvent servletContextEvent) {
        }
    }

    public static interface TraceListener {
        public void handleTrace(String var1);
    }
}

