/*
 * Decompiled with CFR 0.152.
 */
package org.icepush.servlet;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.icepush.Configuration;
import org.icepush.http.PushRequest;
import org.icepush.http.PushResponseHandler;
import org.icepush.http.Request;
import org.icepush.http.ResponseHandler;
import org.icepush.servlet.ServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletPushRequest
extends ServletRequest
implements PushRequest,
Request {
    private static final Logger LOGGER = Logger.getLogger(ServletPushRequest.class.getName());
    private String cachedBrowserID;
    private Long cachedHeartbeatInterval;
    private Long cachedHeartbeatTimestamp;
    private String cachedNotifyBackURI;
    private Set<String> cachedPushIDSet;
    private Long cachedSequenceNumber;
    private String cachedWindowID;

    public ServletPushRequest(HttpServletRequest request, Configuration configuration) throws Exception {
        super(request, configuration);
    }

    @Override
    public String getBrowserID() {
        if (this.cachedBrowserID == null) {
            this.cachedBrowserID = this.getParameter("ice.push.browser");
        }
        return this.cachedBrowserID;
    }

    @Override
    public long getHeartbeatInterval() throws NumberFormatException {
        if (this.cachedHeartbeatInterval == null) {
            this.cachedHeartbeatInterval = this.getParameterAsLong("ice.push.heartbeat");
        }
        return this.cachedHeartbeatInterval;
    }

    @Override
    public long getHeartbeatTimestamp() throws NumberFormatException {
        if (this.cachedHeartbeatTimestamp == null) {
            this.cachedHeartbeatTimestamp = this.getParameterAsLong("ice.push.heartbeatTimestamp", 0L);
        }
        return this.cachedHeartbeatTimestamp;
    }

    @Override
    public String getNotifyBackURI() {
        if (this.cachedNotifyBackURI == null) {
            this.cachedNotifyBackURI = this.getParameter("ice.notifyBack", null);
        }
        return this.cachedNotifyBackURI;
    }

    @Override
    public Set<String> getPushIDSet() {
        if (this.cachedPushIDSet == null) {
            this.cachedPushIDSet = new HashSet<String>(Arrays.asList(this.getParameterAsStrings("ice.pushid")));
        }
        return this.cachedPushIDSet;
    }

    @Override
    public long getSequenceNumber() throws NumberFormatException {
        if (this.cachedSequenceNumber == null) {
            this.cachedSequenceNumber = this.getParameterAsLong("ice.push.sequence", 0L);
        }
        return this.cachedSequenceNumber;
    }

    @Override
    public String getWindowID() {
        if (this.cachedWindowID == null) {
            this.cachedWindowID = this.getParameter("ice.push.window", null);
        }
        return this.cachedWindowID;
    }

    @Override
    public void respondWith(ResponseHandler handler) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void respondWith(PushResponseHandler handler) throws Exception {
        throw new UnsupportedOperationException();
    }
}

