/*
 * Decompiled with CFR 0.152.
 */
package org.icepush.servlet;

import java.util.Set;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.icepush.Configuration;
import org.icepush.http.PushRequest;
import org.icepush.http.PushResponse;
import org.icepush.http.PushResponseHandler;
import org.icepush.http.Request;
import org.icepush.http.Response;
import org.icepush.http.ResponseHandler;
import org.icepush.servlet.ServletPushRequest;
import org.icepush.servlet.ServletPushResponse;
import org.icepush.servlet.ServletRequestResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletPushRequestResponse
extends ServletRequestResponse
implements PushRequest,
PushResponse,
Request,
Response {
    private static final Logger LOGGER = Logger.getLogger(ServletPushRequestResponse.class.getName());
    private final PushRequest pushRequest;
    private final PushResponse pushResponse;

    public ServletPushRequestResponse(HttpServletRequest request, HttpServletResponse response, Configuration configuration) throws Exception {
        this(new ServletPushRequest(request, configuration), new ServletPushResponse(response, configuration));
    }

    public ServletPushRequestResponse(ServletPushRequest pushRequest, ServletPushResponse pushResponse) throws Exception {
        super(pushRequest, pushResponse);
        this.pushRequest = pushRequest;
        this.pushResponse = pushResponse;
    }

    @Override
    public String getBrowserID() {
        return this.pushRequest.getBrowserID();
    }

    @Override
    public long getHeartbeatInterval() throws NumberFormatException {
        return this.pushRequest.getHeartbeatInterval();
    }

    @Override
    public long getHeartbeatTimestamp() throws NumberFormatException {
        return this.pushRequest.getHeartbeatTimestamp();
    }

    @Override
    public String getNotifyBackURI() {
        return this.pushRequest.getNotifyBackURI();
    }

    @Override
    public Set<String> getPushIDSet() {
        return this.pushRequest.getPushIDSet();
    }

    @Override
    public long getSequenceNumber() throws NumberFormatException {
        return this.pushRequest.getSequenceNumber();
    }

    @Override
    public String getWindowID() {
        return this.pushRequest.getWindowID();
    }

    @Override
    public void respondWith(ResponseHandler handler) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void respondWith(PushResponseHandler handler) throws Exception {
        handler.respond(this);
    }

    @Override
    public void setHeartbeatInterval(long heartbeatInterval) {
        this.pushResponse.setHeartbeatInterval(heartbeatInterval);
    }

    @Override
    public void setHeartbeatTimestamp(long heartbeatTimestamp) {
        this.pushResponse.setHeartbeatTimestamp(heartbeatTimestamp);
    }

    @Override
    public void setSequenceNumber(long sequenceNumber) {
        this.pushResponse.setSequenceNumber(sequenceNumber);
    }

    protected PushRequest getPushRequest() {
        return this.pushRequest;
    }

    protected PushResponse getPushResponse() {
        return this.pushResponse;
    }
}

