/*
 * Decompiled with CFR 0.152.
 */
package org.icepush.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.icepush.Configuration;
import org.icepush.http.Request;
import org.icepush.http.ResponseHandler;
import org.icepush.servlet.AbstractRequest;

public class ServletRequest
extends AbstractRequest
implements Request {
    private static final Logger LOGGER = Logger.getLogger(ServletRequest.class.getName());
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
    private final Configuration configuration;
    private final boolean disableRemoteHostLookup;
    private final HttpServletRequest request;
    private final URI requestURI;

    public ServletRequest(HttpServletRequest request, Configuration configuration) throws Exception {
        this.request = request;
        this.configuration = configuration;
        this.disableRemoteHostLookup = this.configuration.getAttributeAsBoolean("disableRemoteHostLookup", false);
        String query = this.request.getQueryString();
        URI uri = null;
        while (null == uri) {
            try {
                uri = URI.create(this.request.getRequestURL().toString());
            }
            catch (NullPointerException exception) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Null Protocol Scheme in request", exception);
                }
                uri = URI.create("http://" + this.request.getServerName() + ":" + this.request.getServerPort() + this.request.getRequestURI());
            }
        }
        this.requestURI = query == null ? uri : URI.create(uri + "?" + query);
    }

    public boolean containsParameter(String name) {
        return this.request.getParameter(name) != null;
    }

    public void detectEnvironment(Request.Environment environment) throws Exception {
    }

    public Object getAttribute(String name) {
        return this.request.getAttribute(name);
    }

    public Cookie[] getCookies() {
        return this.request.getCookies();
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public Date getHeaderAsDate(String name) {
        try {
            return DATE_FORMAT.parse(this.request.getHeader(name));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public int getHeaderAsInteger(String name) throws NumberFormatException {
        return Integer.parseInt(this.request.getHeader(name));
    }

    public long getHeaderAsLong(String name) throws NumberFormatException {
        return Long.parseLong(this.request.getHeader(name));
    }

    public String[] getHeaderAsStrings(String name) {
        Enumeration e = this.request.getHeaders(name);
        ArrayList values = new ArrayList();
        while (e.hasMoreElements()) {
            values.add(e.nextElement());
        }
        return values.toArray(new String[values.size()]);
    }

    public String[] getHeaderNames() {
        ArrayList headerNames = new ArrayList();
        Enumeration e = this.request.getHeaderNames();
        while (e.hasMoreElements()) {
            headerNames.add(e.nextElement());
        }
        return headerNames.toArray(new String[headerNames.size()]);
    }

    public String getLocalAddr() {
        return this.request.getLocalAddr();
    }

    public String getLocalName() {
        return this.request.getLocalName();
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getParameter(String name) {
        this.checkExistenceOf(name);
        return this.request.getParameter(name);
    }

    public String getParameter(String name, String defaultValue) {
        try {
            return this.getParameter(name);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public boolean getParameterAsBoolean(String name) {
        return Boolean.valueOf(this.getParameter(name));
    }

    public boolean getParameterAsBoolean(String name, boolean defaultValue) {
        try {
            return this.getParameterAsBoolean(name);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int getParameterAsInteger(String name) throws NumberFormatException {
        return Integer.parseInt(this.getParameter(name));
    }

    public int getParameterAsInteger(String name, int defaultValue) {
        try {
            return this.getParameterAsInteger(name);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public long getParameterAsLong(String name) throws NumberFormatException {
        return Long.parseLong(this.getParameter(name));
    }

    public long getParameterAsLong(String name, long defaultValue) {
        try {
            return this.getParameterAsLong(name);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public String[] getParameterAsStrings(String name) {
        this.checkExistenceOf(name);
        return this.request.getParameterValues(name);
    }

    public String[] getParameterNames() {
        Set result = this.request.getParameterMap().keySet();
        return result.toArray(new String[result.size()]);
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public String getRemoteHost() {
        if (!this.disableRemoteHostLookup) {
            LOGGER.info("Remote Host: " + this.request.getRemoteHost());
            return this.request.getRemoteHost();
        }
        LOGGER.info("Remote Host: " + this.request.getRemoteAddr());
        return this.request.getRemoteAddr();
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public URI getURI() {
        return this.requestURI;
    }

    public InputStream readBody() throws IOException {
        return this.request.getInputStream();
    }

    public void readBodyInto(OutputStream out) throws IOException {
        ServletRequest.copy(this.readBody(), out);
    }

    public void respondWith(ResponseHandler handler) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void setAttribute(String name, Object value) {
        this.request.setAttribute(name, value);
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    protected HttpServletRequest getHttpServletRequest() {
        return this.request;
    }

    private void checkExistenceOf(String name) {
        if (this.request.getParameter(name) == null) {
            String host = this.getRemoteHost();
            StringBuffer data = new StringBuffer("+ Request does not contain parameter '" + name + "' host: \n");
            data.append("  Originator: ").append(host).append("\n");
            data.append("  Path: ").append(this.requestURI.toString()).append("\n");
            Enumeration e = this.request.getParameterNames();
            int i = 0;
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (i == 0) {
                    data.append("  Available request parameters are: \n");
                }
                data.append("  - parameter name: ").append(key).append(", value: ").append(this.request.getParameter(key)).append("\n");
                ++i;
            }
            if (i == 0) {
                data.append("   Request map is empty!\n");
            }
            data.append("- SRR hashcode: ").append(this.hashCode()).append(" Servlet request hash: ").append(this.request.hashCode());
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(data.toString());
            }
            throw new RuntimeException("Query does not contain parameter named: " + name);
        }
    }

    static {
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

