/*
 * Decompiled with CFR 0.152.
 */
package org.icepush.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import org.icepush.Configuration;
import org.icepush.http.Response;
import org.icepush.servlet.AbstractResponse;

public class ServletResponse
extends AbstractResponse
implements Response {
    private static final Logger LOGGER = Logger.getLogger(ServletResponse.class.getName());
    private static Pattern HEADER_FIXER = null;
    private final Configuration configuration;
    private final HttpServletResponse response;

    public ServletResponse(HttpServletResponse response, Configuration configuration) throws Exception {
        this.response = response;
        this.configuration = configuration;
    }

    public void setHeader(String name, Date value) {
        if (ServletResponse.ignoreHeader(name, value)) {
            return;
        }
        this.response.setDateHeader(name, value.getTime());
    }

    public void setHeader(String name, int value) {
        this.response.setIntHeader(name, value);
    }

    public void setHeader(String name, long value) {
        this.response.setHeader(name, String.valueOf(value));
    }

    public void setHeader(String name, String value) {
        if (ServletResponse.ignoreHeader(name, value)) {
            return;
        }
        String _value = HEADER_FIXER.matcher(value).replaceAll("");
        if ("Content-Type".equals(name)) {
            this.response.setContentType(_value);
        } else if ("Content-Length".equals(name)) {
            this.response.setContentLength(Integer.parseInt(_value));
        } else {
            this.response.setHeader(name, _value);
        }
    }

    public void setHeader(String name, String[] values) {
        if (ServletResponse.ignoreHeader(name, values)) {
            return;
        }
        for (String _value : values) {
            this.response.addHeader(name, HEADER_FIXER.matcher(_value).replaceAll(""));
        }
    }

    public void setStatus(int code) {
        this.response.setStatus(code);
    }

    public OutputStream writeBody() throws IOException {
        return this.response.getOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBodyFrom(InputStream in) throws IOException {
        OutputStream _out = this.writeBody();
        try {
            ServletResponse.copy(in, _out);
        }
        finally {
            try {
                in.close();
            }
            finally {
                _out.close();
            }
        }
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    protected HttpServletResponse getHttpServletResponse() {
        return this.response;
    }

    static {
        HEADER_FIXER = Pattern.compile("[\r\n]");
    }
}

