/*
 * Decompiled with CFR 0.152.
 */
package org.icepush.servlet;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.icepush.Configuration;
import org.icepush.http.PushResponseHandler;
import org.icepush.http.PushServer;
import org.icepush.servlet.PseudoServlet;
import org.icepush.servlet.ServletPushRequestResponse;
import org.icepush.util.Slot;

public class ThreadBlockingAdaptingServlet
implements PseudoServlet {
    private static final Logger LOGGER = Logger.getLogger(ThreadBlockingAdaptingServlet.class.getName());
    private final Configuration configuration;
    private final Slot heartbeatInterval;
    private final PushServer pushServer;

    public ThreadBlockingAdaptingServlet(PushServer pushServer, Slot heartbeatInterval, Configuration configuration) {
        this.pushServer = pushServer;
        this.heartbeatInterval = heartbeatInterval;
        this.configuration = configuration;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ThreadBlockingRequestResponse requestResponse = new ThreadBlockingRequestResponse(request, response, this.configuration);
        this.pushServer.service(requestResponse);
        requestResponse.blockUntilRespond();
    }

    public void shutdown() {
        this.pushServer.shutdown();
    }

    private class ThreadBlockingRequestResponse
    extends ServletPushRequestResponse {
        private final Semaphore semaphore;

        public ThreadBlockingRequestResponse(HttpServletRequest request, HttpServletResponse response, Configuration configuration) throws Exception {
            super(request, response, configuration);
            this.semaphore = new Semaphore(1);
            this.semaphore.acquire();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void respondWith(PushResponseHandler handler) throws Exception {
            try {
                super.respondWith(handler);
            }
            finally {
                this.semaphore.release();
            }
        }

        public void blockUntilRespond() throws InterruptedException {
            long timeout = ThreadBlockingAdaptingServlet.this.heartbeatInterval.getLongValue() * 3L;
            boolean acquired = this.semaphore.tryAcquire(timeout, TimeUnit.MILLISECONDS);
            if (acquired) {
                this.semaphore.release();
            } else {
                LOGGER.warning("No response sent to request '" + this.getPushRequest().getURI() + "' " + "with ICEfaces ID '" + this.getPushRequest().getParameter("ice.session") + "' " + "from " + this.getPushRequest().getRemoteAddr() + " " + "in " + timeout + " milliseconds.  " + "Unblocking " + "thread '" + Thread.currentThread().getName() + "'.");
                this.semaphore.release();
            }
        }
    }
}

