/*
 * Decompiled with CFR 0.152.
 */
package org.icepush.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.icepush.util.ByteCodeAnnotationFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationScanner {
    private static final Logger LOGGER = Logger.getLogger(AnnotationScanner.class.getName());
    private static final char DOT = '.';
    private static final char SLASH = '/';
    private static final String CLASS_EXTENSION = ".class";
    private static final String JAR_EXTENSION = ".jar";
    private static final String JAR_SCHEME = "jar:";
    private static final String JAR_SCHEME_POSTFIX = "!/";
    private static final String META_INF_PREFIX = "META-INF/";
    private static final String WEB_INF_LIB_PREFIX = "/WEB-INF/lib/";
    private final ByteCodeAnnotationFilter filter = new ByteCodeAnnotationFilter();
    private final Set<String> annotationSet;
    private final ServletContext servletContext;

    public AnnotationScanner(Set<String> annotationSet, ServletContext servletContext) throws IllegalArgumentException {
        if (annotationSet == null) {
            throw new IllegalArgumentException("Illegal value of 'annotationSet' parameter: null");
        }
        if (annotationSet.size() == 0) {
            throw new IllegalArgumentException("Illegal value of 'annotationSet' parameter: empty");
        }
        if (servletContext == null) {
            throw new IllegalArgumentException("Illegal value of 'servletContext' parameter: null");
        }
        this.annotationSet = Collections.unmodifiableSet(annotationSet);
        this.servletContext = servletContext;
    }

    public Set<Class> getClassSet() throws IOException {
        HashSet<Class> _classSet = new HashSet<Class>();
        Set<JarFile> _webArchiveList = this.getWebArchives();
        for (JarFile _jarFile : _webArchiveList) {
            _classSet.addAll(this.getClassSet(_jarFile));
        }
        return _classSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Class> getClassSet(JarFile jarFile) {
        HashSet<Class> _classSet = new HashSet<Class>();
        ClassLoader _classLoader = AnnotationScanner.getContextClassLoader();
        if (_classLoader == null) {
            _classLoader = this.getClass().getClassLoader();
        }
        Enumeration<JarEntry> _jarEntries = jarFile.entries();
        while (_jarEntries.hasMoreElements()) {
            JarEntry _jarEntry = _jarEntries.nextElement();
            if (_jarEntry.isDirectory()) {
                if (!LOGGER.isLoggable(Level.FINEST)) continue;
                LOGGER.log(Level.FINEST, "Skip directory: [" + _jarEntry.getName() + "]");
                continue;
            }
            String _name = _jarEntry.getName();
            if (_name.startsWith(META_INF_PREFIX)) {
                if (!LOGGER.isLoggable(Level.FINEST)) continue;
                LOGGER.log(Level.FINEST, "Skip META-INF: [" + _name + "]");
                continue;
            }
            if (!_name.endsWith(CLASS_EXTENSION)) {
                if (!LOGGER.isLoggable(Level.FINEST)) continue;
                LOGGER.log(Level.FINEST, "Skip non-class: [" + _name + "]");
                continue;
            }
            DataInputStream _in = null;
            boolean _containsAnnotation = false;
            try {
                _in = new DataInputStream(jarFile.getInputStream(_jarEntry));
                _containsAnnotation = this.filter.containsAnnotation(_in, this.annotationSet);
            }
            catch (IOException exception) {
                _containsAnnotation = true;
            }
            finally {
                if (_in != null) {
                    try {
                        _in.close();
                    }
                    catch (IOException exception) {}
                }
            }
            if (!_containsAnnotation) continue;
            Class<?> _class = null;
            try {
                _class = _classLoader.loadClass(_name.substring(0, _name.length() - CLASS_EXTENSION.length()).replace('/', '.'));
            }
            catch (ClassNotFoundException exception) {
                // empty catch block
            }
            if (_class == null) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Add class: [" + _class.getName() + "]");
            }
            _classSet.add(_class);
        }
        return _classSet;
    }

    private static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() != null) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() throws Exception {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
            }
            catch (PrivilegedActionException exception) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "An error occurred while getting the context class loader.");
                }
                throw new RuntimeException(exception);
            }
        }
        return Thread.currentThread().getContextClassLoader();
    }

    private Set<JarFile> getWebArchives() {
        HashSet<JarFile> _webArchiveSet = new HashSet<JarFile>();
        Set _resourcePaths = this.servletContext.getResourcePaths(WEB_INF_LIB_PREFIX);
        if (_resourcePaths != null) {
            for (String _resourcePath : _resourcePaths) {
                if (!_resourcePath.endsWith(JAR_EXTENSION)) {
                    if (!LOGGER.isLoggable(Level.FINEST)) continue;
                    LOGGER.log(Level.FINEST, "Skip non-jar: [" + _resourcePath + "]");
                    continue;
                }
                try {
                    JarFile _jarFile = ((JarURLConnection)new URL(JAR_SCHEME + this.servletContext.getResource(_resourcePath).toString() + JAR_SCHEME_POSTFIX).openConnection()).getJarFile();
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Add jar: [" + _resourcePath + "]");
                    }
                    _webArchiveSet.add(_jarFile);
                }
                catch (IOException exception) {
                    if (!LOGGER.isLoggable(Level.FINEST)) continue;
                    LOGGER.log(Level.FINEST, "Skip due to I/O error: [" + _resourcePath + "]");
                }
            }
        }
        return _webArchiveSet;
    }
}

