/*
 * Decompiled with CFR 0.152.
 */
package org.icepush.util;

import java.io.DataInput;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteCodeAnnotationFilter {
    private static final Logger LOGGER = Logger.getLogger(ByteCodeAnnotationFilter.class.getName());
    private static final int MAGIC = -889275714;
    private static final int CONSTANT_CLASS = 7;
    private static final int CONSTANT_FIELDREF = 9;
    private static final int CONSTANT_METHODREF = 10;
    private static final int CONSTANT_INTERFACE_METHODREF = 11;
    private static final int CONSTANT_STRING = 8;
    private static final int CONSTANT_INTEGER = 3;
    private static final int CONSTANT_FLOAT = 4;
    private static final int CONSTANT_LONG = 5;
    private static final int CONSTANT_DOUBLE = 6;
    private static final int CONSTANT_NAME_AND_TYPE = 12;
    private static final int CONSTANT_UTF8 = 1;

    public boolean containsAnnotation(DataInput in, Set<String> byteCodeAnnotationNameSet) throws IOException {
        if (in.readInt() != -889275714) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "This is not a class file.");
            }
            return false;
        }
        in.readUnsignedShort();
        if (in.readUnsignedShort() < 49) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "This is compiled with JDK 1.4 or earlier and therefore does not have annotations.");
            }
            return false;
        }
        int _constantPoolCount = in.readUnsignedShort();
        block9: for (int i = 1; i < _constantPoolCount; ++i) {
            switch (in.readUnsignedByte()) {
                case 7: {
                    in.readUnsignedShort();
                    continue block9;
                }
                case 9: 
                case 10: 
                case 11: {
                    in.readUnsignedShort();
                    in.readUnsignedShort();
                    continue block9;
                }
                case 8: {
                    in.readUnsignedShort();
                    continue block9;
                }
                case 3: 
                case 4: {
                    in.readInt();
                    continue block9;
                }
                case 5: 
                case 6: {
                    in.readInt();
                    in.readInt();
                    continue block9;
                }
                case 12: {
                    in.readUnsignedShort();
                    in.readUnsignedShort();
                    continue block9;
                }
                case 1: {
                    if (!byteCodeAnnotationNameSet.contains(in.readUTF())) continue block9;
                    return true;
                }
                default: {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "This contains corrupt data.");
                    }
                    i = _constantPoolCount;
                }
            }
        }
        return false;
    }
}

