/*
 * Decompiled with CFR 0.152.
 */
package org.icepush.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class ExtensionRegistry
implements ServletContextListener {
    private static final String NAME = ExtensionRegistry.class.getName();

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ExtensionRegistry.addExtensionsMapIfNeeded(servletContextEvent.getServletContext());
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }

    private static void addExtensionsMapIfNeeded(ServletContext context) {
        if (context.getAttribute(NAME) == null) {
            context.setAttribute(NAME, new HashMap());
        }
    }

    public static void addExtension(ServletContext context, int quality, String name, Object extension) {
        ExtensionRegistry.addExtensionsMapIfNeeded(context);
        Map extensions = (Map)context.getAttribute(NAME);
        ArrayList<ExtensionEntry> namedExtensions = (ArrayList<ExtensionEntry>)extensions.get(name);
        if (namedExtensions == null) {
            namedExtensions = new ArrayList<ExtensionEntry>();
            extensions.put(name, namedExtensions);
        }
        namedExtensions.add(new ExtensionEntry(quality, extension));
    }

    public static Object getBestExtension(ServletContext context, String name) {
        Map extensions = (Map)context.getAttribute(NAME);
        ArrayList namedExtensions = (ArrayList)extensions.get(name);
        Collections.sort(namedExtensions);
        return namedExtensions == null ? null : ((ExtensionEntry)namedExtensions.get(namedExtensions.size() - 1)).extension;
    }

    public static Object[] getExtensions(ServletContext context, String name) {
        Map extensions = (Map)context.getAttribute(NAME);
        ArrayList namedExtensions = (ArrayList)extensions.get(name);
        if (null == namedExtensions) {
            return null;
        }
        int size = namedExtensions.size();
        Collections.sort(namedExtensions);
        Iterator it = namedExtensions.iterator();
        Object[] result = new Object[size];
        for (int i = 0; i < size; ++i) {
            result[i] = ((ExtensionEntry)it.next()).extension;
        }
        return result;
    }

    private static class ExtensionEntry
    implements Comparable {
        private int quality;
        private Object extension;

        private ExtensionEntry(int quality, Object extension) {
            this.quality = quality;
            this.extension = extension;
        }

        public int compareTo(Object o) {
            return this.quality - ((ExtensionEntry)o).quality;
        }
    }
}

