/*
 * Decompiled with CFR 0.152.
 */
package org.icepush.util;

import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ThreadFactory
implements java.util.concurrent.ThreadFactory {
    private static final Logger LOGGER = Logger.getLogger(ThreadFactory.class.getName());
    private final ReentrantLock lock = new ReentrantLock();
    private int counter = 0;
    private boolean daemon = true;
    private String prefix = "Thread";

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread newThread(Runnable runnable) {
        Thread _thread;
        block7: {
            this.lock.lock();
            try {
                _thread = new Thread(runnable, this.getPrefix() + " [" + ++this.counter + "]");
            }
            finally {
                this.lock.unlock();
            }
            _thread.setDaemon(this.isDaemon());
            try {
                _thread.setContextClassLoader(runnable.getClass().getClassLoader());
            }
            catch (SecurityException exception) {
                if (!LOGGER.isLoggable(Level.FINEST)) break block7;
                LOGGER.log(Level.FINEST, "Setting the context class loader is not permitted.", exception);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "New thread: " + _thread.getName());
        }
        return _thread;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

