/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.application;

import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpSession;
import org.icefaces.application.PortableRenderer;
import org.icefaces.application.PushIsolator;
import org.icefaces.application.PushOptions;
import org.icefaces.impl.application.LazyPushManager;
import org.icefaces.impl.event.BridgeSetup;
import org.icefaces.impl.push.SessionViewManager;
import org.icefaces.util.EnvUtils;
import org.icepush.PushContext;

public class PushRenderer {
    private static Logger log = Logger.getLogger(PushRenderer.class.getName());
    private static final String MissingICEpushMessage = "ICEpush library missing. Push notification disabled.";
    private static final PortableRenderer MissingICEpushPortableRenderer = new PortableRenderer(){

        @Override
        public void render(String group) {
            log.warning(PushRenderer.MissingICEpushMessage);
        }

        @Override
        public void render(String group, PushOptions options) {
            log.warning(PushRenderer.MissingICEpushMessage);
        }

        @Override
        public void addCurrentSession(String groupName) {
            log.warning(PushRenderer.MissingICEpushMessage);
        }

        @Override
        public void removeCurrentSession(String groupName) {
            log.warning(PushRenderer.MissingICEpushMessage);
        }
    };

    public static synchronized void addCurrentView(String groupName) {
        if (EnvUtils.isICEpushPresent()) {
            FacesContext context = FacesContext.getCurrentInstance();
            PushRenderer.missingFacesContext(context);
            String viewID = PushRenderer.lookupViewState(context);
            LazyPushManager.get(context).enablePushForView(viewID);
            PushContext pushContext = (PushContext)context.getExternalContext().getApplicationMap().get(PushContext.class.getName());
            pushContext.addGroupMember(groupName, viewID);
        } else {
            log.warning(MissingICEpushMessage);
        }
    }

    public static synchronized String getCurrentViewPushID() {
        if (EnvUtils.isICEpushPresent()) {
            FacesContext context = FacesContext.getCurrentInstance();
            PushRenderer.missingFacesContext(context);
            return PushRenderer.lookupViewState(context);
        }
        log.warning(MissingICEpushMessage);
        return null;
    }

    public static synchronized void removeCurrentView(String groupName) {
        if (EnvUtils.isICEpushPresent()) {
            FacesContext context = FacesContext.getCurrentInstance();
            PushRenderer.missingFacesContext(context);
            String viewID = PushRenderer.lookupViewState(context);
            LazyPushManager.get(context).disablePushForView(viewID);
            PushContext pushContext = (PushContext)context.getExternalContext().getApplicationMap().get(PushContext.class.getName());
            pushContext.removeGroupMember(groupName, viewID);
        } else {
            log.warning(MissingICEpushMessage);
        }
    }

    public static synchronized void addCurrentSession(String groupName) {
        if (EnvUtils.isICEpushPresent()) {
            FacesContext context = FacesContext.getCurrentInstance();
            PushRenderer.missingFacesContext(context);
            LazyPushManager.get(context).enablePushForSessionViews();
            SessionViewManager.get(context).addCurrentSessionToGroup(groupName);
        } else {
            log.warning(MissingICEpushMessage);
        }
    }

    public static synchronized Set<String> getCurrentSessionPushIDSet() {
        if (EnvUtils.isICEpushPresent()) {
            FacesContext context = FacesContext.getCurrentInstance();
            PushRenderer.missingFacesContext(context);
            return SessionViewManager.get(context).getCurrentSessionViewSet();
        }
        log.warning(MissingICEpushMessage);
        return null;
    }

    public static synchronized void removeCurrentSession(String groupName) {
        if (EnvUtils.isICEpushPresent()) {
            FacesContext context = FacesContext.getCurrentInstance();
            PushRenderer.missingFacesContext(context);
            LazyPushManager.get(context).disablePushForSessionViews();
            SessionViewManager.get(context).removeCurrentSessionFromGroup(groupName);
        } else {
            log.warning(MissingICEpushMessage);
        }
    }

    public static synchronized PushContext getPushContext() {
        if (EnvUtils.isICEpushPresent()) {
            FacesContext context = FacesContext.getCurrentInstance();
            PushRenderer.missingFacesContext(context);
            return (PushContext)context.getExternalContext().getApplicationMap().get(PushContext.class.getName());
        }
        log.warning(MissingICEpushMessage);
        return null;
    }

    public static void render(String groupName) {
        if (EnvUtils.isICEpushPresent()) {
            FacesContext context = FacesContext.getCurrentInstance();
            PushRenderer.missingFacesContext(context);
            PushContext pushContext = (PushContext)context.getExternalContext().getApplicationMap().get(PushContext.class.getName());
            pushContext.push(groupName);
        } else {
            log.warning(MissingICEpushMessage);
        }
    }

    public static void render(String group, PushOptions options) {
        if (EnvUtils.isICEpushPresent()) {
            FacesContext context = FacesContext.getCurrentInstance();
            PushRenderer.missingFacesContext(context);
            Boolean pushOthers = (Boolean)options.getAttributes().get("pushOthers");
            if (pushOthers != null && pushOthers.booleanValue()) {
                options.getAttributes().put("pushIDSet", SessionViewManager.get(context).getCurrentSessionViewSet());
            }
            Map applicationMap = context.getExternalContext().getApplicationMap();
            PushIsolator.render(applicationMap, group, options);
        } else {
            log.warning(MissingICEpushMessage);
        }
    }

    public static PortableRenderer getPortableRenderer() {
        if (EnvUtils.isICEpushPresent()) {
            FacesContext context = FacesContext.getCurrentInstance();
            Map applicationMap = context.getExternalContext().getApplicationMap();
            Map sessionMap = null;
            Object session = null;
            try {
                sessionMap = context.getExternalContext().getSessionMap();
                session = context.getExternalContext().getSession(true);
            }
            catch (UnsupportedOperationException e) {
                log.fine("The created PortableRenderer cannot add/remove session's views to/from the provided group.");
            }
            return new FacesContextBasedPortableRenderer(applicationMap, sessionMap, session);
        }
        log.warning(MissingICEpushMessage);
        return MissingICEpushPortableRenderer;
    }

    public static PortableRenderer getPortableRenderer(HttpSession session) {
        if (EnvUtils.isICEpushPresent()) {
            return new HttpSessionBasedPortableRenderer(session);
        }
        log.warning(MissingICEpushMessage);
        return MissingICEpushPortableRenderer;
    }

    private static String lookupViewState(FacesContext context) {
        return BridgeSetup.getViewID(context.getExternalContext());
    }

    private static void missingFacesContext(FacesContext context) {
        if (context == null) {
            throw new RuntimeException("FacesContext is not present for thread " + Thread.currentThread());
        }
    }

    private static class HttpSessionBasedPortableRenderer
    implements PortableRenderer {
        private final HttpSession session;

        public HttpSessionBasedPortableRenderer(HttpSession session) {
            this.session = session;
        }

        @Override
        public void render(String group) {
            PushContext pushContext = (PushContext)this.session.getServletContext().getAttribute(PushContext.class.getName());
            if (pushContext == null) {
                log.fine("PushContext not initialized yet.");
            } else {
                pushContext.push(group);
            }
        }

        @Override
        public void render(String group, PushOptions options) {
            PushIsolator.render(this.session.getServletContext(), group, options);
        }

        @Override
        public void addCurrentSession(String groupName) {
            LazyPushManager.get(this.session).enablePushForSessionViews();
            SessionViewManager.get(this.session).addCurrentSessionToGroup(groupName);
        }

        @Override
        public void removeCurrentSession(String groupName) {
            LazyPushManager.get(this.session).disablePushForSessionViews();
            SessionViewManager.get(this.session).removeCurrentSessionFromGroup(groupName);
        }
    }

    private static class FacesContextBasedPortableRenderer
    implements PortableRenderer {
        private final Map<String, Object> applicationMap;
        private final Map sessionMap;
        private final Object session;

        public FacesContextBasedPortableRenderer(Map<String, Object> applicationMap, Map sessionMap, Object session) {
            this.applicationMap = applicationMap;
            this.sessionMap = sessionMap;
            this.session = session;
        }

        @Override
        public void render(String group) {
            PushContext pushContext = (PushContext)this.applicationMap.get(PushContext.class.getName());
            if (pushContext == null) {
                log.fine("PushContext not initialized yet.");
            } else {
                pushContext.push(group);
            }
        }

        @Override
        public void render(String group, PushOptions options) {
            PushIsolator.render(this.applicationMap, group, options);
        }

        @Override
        public void addCurrentSession(String groupName) {
            if (this.sessionMap == null) {
                log.fine("Cannot add session's views to the provided group.");
            } else {
                LazyPushManager.get(this.sessionMap).enablePushForSessionViews();
                SessionViewManager.get(this.applicationMap, this.sessionMap, this.session).addCurrentSessionToGroup(groupName);
            }
        }

        @Override
        public void removeCurrentSession(String groupName) {
            if (this.sessionMap == null) {
                log.fine("Cannot remove session's views from the provided group.");
            } else {
                LazyPushManager.get(this.sessionMap).disablePushForSessionViews();
                SessionViewManager.get(this.applicationMap, this.sessionMap, this.session).removeCurrentSessionFromGroup(groupName);
            }
        }
    }
}

