/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.application;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.servlet.http.HttpSession;
import org.icefaces.application.ResourceRegistryHolder;
import org.icefaces.impl.application.SessionAwareResourceHandlerWrapper;
import org.icefaces.impl.application.WindowScopeManager;
import org.icefaces.impl.util.Util;
import org.icefaces.util.EnvUtils;

public class ResourceRegistry
extends SessionAwareResourceHandlerWrapper {
    private static final String VIEW_ID_PARAMETER = "ice.view";
    private static final String JAVAX_FACES_VIEW_STATE = "javax.faces.ViewState";
    private static final String WINDOW_ID_PARAMETER = "ice.window";
    private static final String WINDOW_SCOPE = "w";
    private static final String VIEW_SCOPE = "v";
    private static final String SESSION_SCOPE = "s";
    private static final String APPLICATION_SCOPE = "a";
    private static final Logger log = Logger.getLogger(ResourceRegistry.class.getName());
    private ResourceHandler wrapped;
    private static String RESOURCE_PREFIX = "/javax.faces.resource/";
    private static String MAP_PREFIX = "org.icefaces.resource-";
    private static String BYTES_PREFIX = "bytes=";
    private static String CONTENT_LENGTH = "Content-Length";
    private static String CONTENT_RANGE = "Content-Range";
    private static String RANGE = "Range";

    public ResourceRegistry(ResourceHandler wrapped) {
        this.wrapped = wrapped;
    }

    public ResourceHandler getWrapped() {
        return this.wrapped;
    }

    @Override
    public boolean isSessionAwareResourceRequest(FacesContext context) {
        return this.wrapped.isResourceRequest(context);
    }

    @Override
    public void handleSessionAwareResourceRequest(FacesContext facesContext) throws IOException {
        HttpSession session;
        int rangeEnd;
        int rangeStart;
        boolean useRanges;
        String key;
        ExternalContext externalContext;
        block19: {
            externalContext = facesContext.getExternalContext();
            key = ResourceRegistry.extractResourceId(facesContext);
            log.finest("extractResourceId: " + key);
            String viewID = (String)externalContext.getRequestParameterMap().get(VIEW_ID_PARAMETER);
            if (viewID != null) {
                facesContext.setCurrentPhaseId(PhaseId.RESTORE_VIEW);
                facesContext.getApplication().getViewHandler().restoreView(facesContext, viewID);
            }
            useRanges = false;
            rangeStart = 0;
            rangeEnd = 0;
            String rangeHeader = (String)externalContext.getRequestHeaderMap().get(RANGE);
            if (null != rangeHeader) {
                try {
                    if (rangeHeader.startsWith(BYTES_PREFIX)) {
                        String range = rangeHeader.substring(BYTES_PREFIX.length());
                        int splitIndex = range.indexOf("-");
                        String startString = range.substring(0, splitIndex);
                        String endString = range.substring(splitIndex + 1);
                        rangeStart = Integer.parseInt(startString);
                        if (!"".equals(endString)) {
                            rangeEnd = Integer.parseInt(endString);
                        }
                        useRanges = true;
                    }
                }
                catch (Exception e) {
                    useRanges = false;
                    if (!log.isLoggable(Level.FINE)) break block19;
                    log.fine("Unable to decode range header " + rangeHeader);
                }
            }
        }
        if (useRanges) {
            externalContext.setResponseStatus(206);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("handleResourceRequest " + key + " path: " + externalContext.getRequestServletPath() + " info: " + externalContext.getRequestPathInfo());
        }
        if (null == key) {
            this.wrapped.handleResourceRequest(facesContext);
            return;
        }
        ELContext elContext = facesContext.getELContext();
        ResourceRegistryHolder holder = (ResourceRegistryHolder)elContext.getELResolver().getValue(elContext, null, (Object)(MAP_PREFIX + key));
        log.finest("ELResolver ResourceRegistryHolder: " + holder);
        if (null == holder && (session = EnvUtils.getSafeSession(facesContext, false)) != null) {
            holder = (ResourceRegistryHolder)session.getAttribute(MAP_PREFIX + key);
            log.finest("Session ResourceRegistryHolder: " + holder);
            if (null != holder && log.isLoggable(Level.FINE)) {
                log.fine("Resource lookup required direct sesssion access");
            }
        }
        if (null == holder) {
            this.wrapped.handleResourceRequest(facesContext);
            return;
        }
        Resource resource = holder.resource;
        log.finest("Resource: " + resource);
        String contentType = resource.getContentType();
        if (contentType != null) {
            externalContext.setResponseContentType(resource.getContentType());
        }
        Map headers = resource.getResponseHeaders();
        String contentLength = "";
        for (String header : headers.keySet()) {
            if (useRanges && CONTENT_LENGTH.equals(header)) {
                contentLength = (String)headers.get(CONTENT_LENGTH);
                continue;
            }
            externalContext.setResponseHeader(header, (String)headers.get(header));
        }
        InputStream in = resource.getInputStream();
        OutputStream out = externalContext.getResponseOutputStream();
        if (Util.acceptGzip(externalContext) && EnvUtils.isCompressResources(facesContext) && Util.shouldCompress(resource.getContentType())) {
            externalContext.setResponseHeader("Content-Encoding", "gzip");
            Util.compressStream(in, out);
        } else {
            externalContext.setResponseHeader("Accept-Ranges", "bytes");
            if (useRanges) {
                int cl = Integer.parseInt(contentLength);
                rangeEnd = rangeEnd == 0 ? cl - 1 : rangeEnd;
                externalContext.setResponseHeader(CONTENT_RANGE, "bytes " + rangeStart + "-" + rangeEnd + "/" + contentLength);
                externalContext.setResponseHeader(CONTENT_LENGTH, "" + (1 + rangeEnd - rangeStart));
                Util.copyStream(in, out, rangeStart, rangeEnd);
            } else {
                Util.copyStream(in, out);
            }
        }
    }

    public static String addResource(Map scopeMap, Resource resource) {
        return ResourceRegistry.addResource("r", scopeMap, resource);
    }

    private static String addResource(String prefix, Map scopeMap, Resource resource) {
        String name = resource.getResourceName();
        String key = null != name && name.length() > 0 ? name : prefix + UUID.randomUUID().toString();
        ResourceRegistryHolder holder = new ResourceRegistryHolder(key, resource);
        scopeMap.put(MAP_PREFIX + key, holder);
        FacesContext context = FacesContext.getCurrentInstance();
        String[] pathTemplate = EnvUtils.getPathTemplate();
        String path = pathTemplate[0] + key + pathTemplate[1];
        if (SESSION_SCOPE == prefix) {
            EnvUtils.getSafeSession(context).setAttribute(MAP_PREFIX + key, (Object)holder);
        }
        if (WINDOW_SCOPE == prefix) {
            String windowID = WindowScopeManager.lookupAssociatedWindowID(context.getExternalContext().getRequestMap());
            path = path.indexOf(63) > 0 ? path + "&" + WINDOW_ID_PARAMETER + "=" + windowID : path + "?" + WINDOW_ID_PARAMETER + "=" + windowID;
        }
        if (VIEW_SCOPE == prefix) {
            String viewState = context.getApplication().getStateManager().getViewState(context);
            String viewId = context.getViewRoot().getViewId();
            path = path.indexOf(63) > 0 ? path + "&" + JAVAX_FACES_VIEW_STATE + "=" + viewState + "&" + VIEW_ID_PARAMETER + "=" + viewId : path + "?" + JAVAX_FACES_VIEW_STATE + "=" + viewState + "&" + VIEW_ID_PARAMETER + "=" + viewId;
        }
        path = context.getExternalContext().encodeResourceURL(path);
        log.finest("\nresourceName: " + name + "\nkey: " + key + "\nholder: " + holder + "\npath: " + path);
        return path;
    }

    private static String extractResourceId(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        int markerStart = -1;
        String path = externalContext.getRequestServletPath();
        if (path != null) {
            markerStart = path.indexOf(RESOURCE_PREFIX);
        }
        if (-1 == markerStart && (path = externalContext.getRequestPathInfo()) != null) {
            markerStart = path.indexOf(RESOURCE_PREFIX);
        }
        if (-1 == markerStart) {
            String resId = "javax.faces.resource";
            Iterator names = externalContext.getRequestParameterNames();
            while (names.hasNext()) {
                int suffixStart;
                String name = (String)names.next();
                if (!name.equalsIgnoreCase("javax.faces.resource") && !name.endsWith("javax.faces.resource")) continue;
                String res = (String)externalContext.getRequestParameterMap().get(name);
                String[] pathTemplate = EnvUtils.getPathTemplate();
                String suffix = pathTemplate[1];
                if (suffix != null && suffix.trim().length() > 0 && (suffixStart = res.indexOf(suffix)) > 0) {
                    res = res.substring(0, suffixStart);
                }
                return res;
            }
        }
        if (-1 == markerStart) {
            return null;
        }
        try {
            String key = path.substring(markerStart + RESOURCE_PREFIX.length(), path.length() - EnvUtils.getPathTemplate()[1].length());
            return key;
        }
        catch (Exception e) {
            log.log(Level.FINE, "could not extract resource id", e);
            return null;
        }
    }

    public static Resource getResourceByName(FacesContext facesContext, String resName) {
        HttpSession session;
        log.finest("resName: " + resName);
        log.finest("lookup : '" + MAP_PREFIX + resName + "'");
        if (resName == null) {
            return null;
        }
        ELContext elContext = facesContext.getELContext();
        ResourceRegistryHolder holder = (ResourceRegistryHolder)elContext.getELResolver().getValue(elContext, null, (Object)(MAP_PREFIX + resName));
        log.finest("ELResolver ResourceRegistryHolder: " + holder);
        if (holder == null && (session = EnvUtils.getSafeSession(facesContext, false)) != null) {
            holder = (ResourceRegistryHolder)session.getAttribute(MAP_PREFIX + resName);
            log.finest("Session ResourceRegistryHolder: " + holder);
        }
        if (null == holder) {
            return null;
        }
        return holder.resource;
    }

    public static String addApplicationResource(Resource resource) {
        return ResourceRegistry.addResource(APPLICATION_SCOPE, FacesContext.getCurrentInstance().getExternalContext().getApplicationMap(), resource);
    }

    public static String addSessionResource(Resource resource) {
        return ResourceRegistry.addResource(SESSION_SCOPE, FacesContext.getCurrentInstance().getExternalContext().getSessionMap(), resource);
    }

    public static String addViewResource(Resource resource) {
        return ResourceRegistry.addResource(VIEW_SCOPE, FacesContext.getCurrentInstance().getViewRoot().getViewMap(), resource);
    }

    public static String addWindowResource(Resource resource) {
        return ResourceRegistry.addResource(WINDOW_SCOPE, WindowScopeManager.lookupWindowScope(FacesContext.getCurrentInstance()), resource);
    }
}

